package com.xdja.cssp.as.service.util;

import java.security.Key;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.KeySpec;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

import org.apache.commons.codec.binary.Base64;

/**
 * 非国密加密签名工具类
 * @author wyf
 *
 */
public class EncryptUtils {
	
	/**
	 * 公钥加密
	 * 
	 * @throws Exception
	 */
	public static byte[] publicEncrypt(String transformation, PublicKey publicKey, byte[] data) throws Exception {
		Cipher cipher = Cipher.getInstance(transformation);
		cipher.init(Cipher.ENCRYPT_MODE, publicKey);

		byte[] results = cipher.doFinal(data);
		return results;
	}

	/**
	 * 私钥解密
	 * 
	 * @throws Exception
	 */
	public static byte[] privatecDecrypt(String transformation, PrivateKey privateKey, byte[] data) throws Exception {
		Cipher cipher = Cipher.getInstance(transformation);
		cipher.init(Cipher.DECRYPT_MODE, privateKey);
		
		byte[] results = cipher.doFinal(data);
		return results;
	}
	
	/**
	 * 
	 * @Description：公钥加密（base64）
	 * @param transformation
	 * @param publicKey
	 * @param data
	 * @return base64
	 * @throws Exception
	 */
	public static String publicEncrypt(String transformation, PublicKey publicKey, String data) throws Exception {
		String encryptData = Base64.encodeBase64String(EncryptUtils.publicEncrypt(transformation, publicKey, data.getBytes("utf-8")));
		return encryptData;
	}
	
	/**
	 * 
	 * @Description：私钥解密（base64）
	 * @param transformation
	 * @param privateKey
	 * @param data base64
	 * @return
	 * @throws Exception
	 */
	public static String privatecDecrypt(String transformation, PrivateKey privateKey, String data) throws Exception {
		String encryptData = new String(EncryptUtils.privatecDecrypt(transformation, privateKey, Base64.decodeBase64(data)), "UTF-8");
		return encryptData;
	}
	
	/**
	 * 签名
	 * 
	 * @throws Exception
	 */
	public static byte[] sign(String algo, PrivateKey privateKey, byte[] data) throws Exception {
		Signature sign = Signature.getInstance(algo);
		sign.initSign(privateKey);
		sign.update(data);
		byte[] signature = sign.sign();
		return signature;
	}
	
	/**
	 * 
	 * @Description：签名（base64）
	 * @param algo
	 * @param data
	 * @return base64
	 * @throws Exception
	 */
	public static String sign(String algo, PrivateKey privateKey, String data) throws Exception {
		Signature sign = Signature.getInstance(algo);
		sign.initSign(privateKey);
		sign.update(data.getBytes("UTF-8"));
		String signature = Base64.encodeBase64String(sign.sign());
		return signature;
	}
	
	/**
	 * 验签
	 * 
	 * @throws Exception
	 */
	public static boolean verifySignature(String algo, PublicKey publicKey, byte[] data, byte[] signature) throws Exception {
		Signature sign = Signature.getInstance(algo);
		sign.initVerify(publicKey);
		sign.update(data);
		if (sign.verify(signature)) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	 * 
	 * @Description：验签（base64）
	 * @param algo
	 * @param data
	 * @param signature base64
	 * @return
	 * @throws Exception
	 */
	public static boolean verifySignature(String algo, PublicKey publicKey, String data, String signature) throws Exception {
		Signature sign = Signature.getInstance(algo);
		sign.initVerify(publicKey);
		sign.update(data.getBytes("UTF-8"));
		if (sign.verify(Base64.decodeBase64(signature))) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	 * 
	 * 密钥加密
	 * 
	 * @throws Exception
	 */
	public static byte[] encrypt(String transformation, byte[] key, byte[] data) throws Exception {
		Key k = toKey(transformation, key);
		Cipher cipher = Cipher.getInstance(transformation);
		cipher.init(Cipher.ENCRYPT_MODE, k);
		byte[] results = cipher.doFinal(data);
		return results;
	}
	
	/**
	 * 
	 * @Description：密钥加密（base64）
	 * @param transformation
	 * @param key
	 * @param data
	 * @return base64
	 * @throws Exception
	 */
	public static String encrypt(String transformation, String key, String data) throws Exception {
		Key k = toKey(transformation, key.getBytes("utf-8"));
		Cipher cipher = Cipher.getInstance(transformation);
		cipher.init(Cipher.ENCRYPT_MODE, k);
		String encryptData = Base64.encodeBase64String(cipher.doFinal(data.getBytes("utf-8")));
		return encryptData;
	}
	
	/**
	 * 
	 * 密钥解密
	 * 
	 * @throws Exception
	 */
	public static byte[] decrypt(String transformation, byte[] key, byte[] data) throws Exception {
		Key k = toKey(transformation, key);
		Cipher cipher = Cipher.getInstance(transformation);
		cipher.init(Cipher.DECRYPT_MODE, k);
		byte[] results = cipher.doFinal(data);
		return results;
	}
	
	/**
	 * 
	 * @Description：密钥解密（base64）
	 * @param transformation
	 * @param key
	 * @param data base64
	 * @return
	 * @throws Exception
	 */
	public static String decrypt(String transformation, String key, String data) throws Exception {
		Key k = toKey(transformation, key.getBytes("UTF-8"));
		Cipher cipher = Cipher.getInstance(transformation);
		cipher.init(Cipher.DECRYPT_MODE, k);
		String encryptData = new String(cipher.doFinal(Base64.decodeBase64(data)), "UTF-8");
		return encryptData;
	}
	
	private static Key toKey(String transformation, byte[] key) throws Exception {
		String[] algo = transformation.split("/");
		KeySpec keySpec;
		if (algo[0].equals("DES")) {
			keySpec = new DESKeySpec(key);
		} else {
			throw new Exception("Not support algorithm");
		}
		SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(algo[0]);
		SecretKey secretKey = keyFactory.generateSecret(keySpec);
		return secretKey;
	}
	
	/**
	 * 
	 * 方法描述：验证签名数据（SHA1WithRSA签名数据）
	 * @author: 谢文超
	 * @date: 2015-5-13 上午9:41:53
	 * @param algo	签名加密算法
	 * @param publicKey	公钥
	 * @param data	签名原文
	 * @param signature	签名数据
	 * @return true 验证通过 false 验证未通过
	 * @throws Exception
	 */
	public static boolean sha1WithRsaVerifySignature(PublicKey publicKey, 
			byte[] data, byte[] signature) throws Exception {
		Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
		cipher.init(Cipher.DECRYPT_MODE, publicKey);
		cipher.update(signature);
		byte[] plainHash = cipher.doFinal();
		System.out.println(new String(data));
		System.out.println(signature.length);
		MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
//		messageDigest.update(data);
		byte[] oriHash = messageDigest.digest(data);
		
		for(int i= 0; i < plainHash.length; i++) {
			if (plainHash[i] != oriHash[i]) {
				return false;
			}
		}
		
		return true;
	}
	
	/**
	 * 
	 * 方法描述：签名数据（SHA1WithRSA签名数据）
	 * @author: 谢文超
	 * @date: 2015-5-13 上午9:41:53
	 * @param algo	签名加密算法
	 * @param publicKey	公钥
	 * @param data	签名原文
	 * @return 签名数据
	 * @throws Exception
	 */
	public static byte[] sha1WithRsaSign(String algo, PrivateKey privateKey, 
			byte[] data) throws Exception {
		MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
		messageDigest.update(data);
		byte[] digestData = messageDigest.digest();
	
		Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
		cipher.init(Cipher.ENCRYPT_MODE, privateKey);
		byte[] signData = cipher.doFinal(digestData);
		return signData;
	}
	
}