package com.xdja.cssp.as.service.util;

import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;

import com.xdja.cssp.as.service.SignConst;

/**
 * 签名工具类
 * @author wyf
 *
 */
public class SignUtils {
	
	/**
	 * 验签
	 * 
	 * @throws Exception
	 */
	public static boolean verifySignature(String algo, PublicKey publicKey, byte[] data, byte[] signature) throws Exception {
		boolean flag;
		if (algo.equals(SignConst.HTTP_HEADER_SIGN_METHOD_SM2)) {
			flag = SM2Utils.verify((ECPublicKey) publicKey, signature, data);
		} else {
			flag =  EncryptUtils.sha1WithRsaVerifySignature(publicKey, data, signature);
		}
		return flag;
	}
}
