/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ras.business.impl;

import com.xdja.cssp.acs.IAssetService;
import com.xdja.cssp.acs.ICertService;
import com.xdja.cssp.acs.bean.asset.Asset;
import com.xdja.cssp.acs.bean.cert.CertStatus;
import com.xdja.cssp.ras.business.interfaces.IRegistBusiness;
import com.xdja.cssp.ras.business.vo.AccountInfo;
import com.xdja.cssp.ras.service.bean.auth.Regist;
import com.xdja.cssp.ras.service.bean.result.RegistResult;
import com.xdja.platform.microservice.db.Dao;
import com.xdja.platform.microservice.db.tx.IAtom;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class RegistBusinessImpl
implements IRegistBusiness {
    private static final String SQL_REG_ACCOUNT = "insert into t_account_info(c_account, c_password, c_register_time) values(?, ?, ?)";
    private static final String SQL_REG_ASSERT = "insert into t_account_asset(c_account, c_asset_identify, c_device_name, n_asset_type, c_card_no) values(?, ?, ?, ?, ?)";
    private static final Logger logger = LoggerFactory.getLogger(RegistBusinessImpl.class);
    private static final Dao dao = Dao.use((String)"RAS");

    public RegistResult regist(Regist regist) throws Exception {
        AccountInfo account = this.getAccount(regist.getAccount());
        if (account != null && StringUtils.isNotBlank((CharSequence)account.getAccount())) {
            logger.error("\u8d26\u6237\u5df2\u5b58\u5728:" + account.getAccount());
            return new RegistResult(1, "\u8d26\u6237\u5df2\u5b58\u5728");
        }
        if (!this.isDevExists(regist.getDeviceId())) {
            logger.error("\u8be5\u8bbe\u5907\u5728\u8d44\u4ea7\u5e93\u4e0d\u5b58\u5728:" + regist.getDeviceId());
            return new RegistResult(2, "\u8be5\u8bbe\u5907\u5728\u8d44\u4ea7\u5e93\u4e0d\u5b58\u5728");
        }
        CertStatus certState = this.getCardStatus(regist);
        if (certState.value != CertStatus.SUCCESS.value) {
            return RegistBusinessImpl.makeCertResult((CertStatus)certState, (Regist)regist);
        }
        return this.registAccountDevice(regist);
    }

    public RegistResult registAccountDevice(Regist regist) throws Exception {
        List deviceList = this.getAssets(new String[]{regist.getDeviceId()});
        if (deviceList == null || deviceList.size() <= 0) {
            logger.error("\u8d44\u4ea7\u6570\u636e\u5e93\u4e2d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8bbe\u5907\uff1a" + regist.getDeviceId());
            return new RegistResult(2, "\u8be5\u8bbe\u5907\u5728\u8d44\u4ea7\u5e93\u4e0d\u5b58\u5728");
        }
        List cardList = this.getAssets(new String[]{((Asset)deviceList.get(0)).getRelatedAsset()});
        if (cardList == null || cardList.size() <= 0) {
            logger.error("\u8d44\u4ea7\u6570\u636e\u5e93\u4e2d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8bbe\u5907\u7684USBKey:" + regist.getDeviceId());
            return new RegistResult(3, "\u8be5\u5b89\u5168\u5361\u5728\u8d44\u4ea7\u5e93\u4e0d\u5b58\u5728");
        }
        Object[][] param = new Object[1 + cardList.size()][5];
        param[0][0] = regist.getAccount();
        param[0][1] = ((Asset)deviceList.get(0)).getIdentity();
        param[0][2] = "deviceName";
        param[0][3] = ((Asset)deviceList.get((int)0)).getType().value;
        param[0][4] = ((Asset)deviceList.get(0)).getCardNo();
        int i = 1;
        for (Asset as : cardList) {
            param[i][0] = regist.getAccount();
            param[i][1] = as.getIdentity();
            param[i][2] = "deviceName";
            param[i][3] = as.getType().value;
            param[i][4] = as.getCardNo();
            ++i;
        }
        dao.tx((IAtom)new /* Unavailable Anonymous Inner Class!! */);
        return new RegistResult(0, "\u8d26\u53f7\u6ce8\u518c\u6210\u529f");
    }

    public static RegistResult makeCertResult(CertStatus certState, Regist regist) {
        RegistResult result;
        switch (certState.value) {
            case 2: {
                logger.error("CertStatus.CARDNOTEXISTS:" + regist.getCardNo());
                result = new RegistResult(3, "\u8be5\u5b89\u5168\u5361\u5728\u8d44\u4ea7\u5e93\u4e0d\u5b58\u5728");
                break;
            }
            case 3: {
                logger.error("CertStatus.CERTNOTEXISTS:" + regist.getCertSn());
                result = new RegistResult(3, "\u8be5\u5b89\u5168\u5361\u5728\u8d44\u4ea7\u5e93\u4e0d\u5b58\u5728");
                break;
            }
            case 4: {
                logger.error("CertStatus.DISACCORD:" + regist.getCardNo() + " " + regist.getCertSn());
                result = new RegistResult(6, "\u5361\u53f7\u4e0eSN\u4e0d\u5bf9\u5e94");
                break;
            }
            case 5: {
                logger.error("CertStatus.CERTBLOCK:" + regist.getCardNo() + " " + regist.getCertSn());
                result = new RegistResult(7, "\u8bc1\u4e66\u88ab\u51bb\u7ed3");
                break;
            }
            case 6: {
                logger.error("CertStatus.CERTREVOKE:" + regist.getCardNo() + " " + regist.getCertSn());
                result = new RegistResult(8, "\u8bc1\u4e66\u88ab\u540a\u9500");
                break;
            }
            default: {
                logger.error("CertStatus.CERTREVOKE:" + regist.getCardNo() + " " + regist.getCertSn());
                result = new RegistResult(-201, "\u53c2\u6570\u9519\u8bef");
            }
        }
        return result;
    }

    public RegistResult bandDevice(Regist regist) throws Exception {
        return null;
    }

    public AccountInfo getAccount(String account) throws SQLException {
        return (AccountInfo)dao.queryForObject(AccountInfo.class, "select n_id as id, c_account as account, c_password as pwd from t_account_info where c_account = ?", new Object[]{account});
    }

    public List<Asset> getAssets(String ... as) {
        IAssetService assetService = (IAssetService)DefaultServiceRefer.getServiceRefer(IAssetService.class);
        return assetService.queryAssets(as);
    }

    public boolean isDevExists(String deviceId) throws Exception {
        IAssetService assetService = (IAssetService)DefaultServiceRefer.getServiceRefer(IAssetService.class);
        return assetService.exists(deviceId);
    }

    public CertStatus getCardStatus(Regist regist) {
        ICertService certService = (ICertService)DefaultServiceRefer.getServiceRefer(ICertService.class);
        return certService.checkCertStatus(regist.getCardNo(), regist.getCertSn());
    }

    static /* synthetic */ Dao access$000() {
        return dao;
    }
}

