/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ras.service;

import com.xdja.platform.microservice.ServiceException;
import com.xdja.platform.microservice.config.MicroServiceConfig;
import com.xdja.platform.microservice.db.DataSourceProvider;
import com.xdja.platform.microservice.db.DbUtilsPlugin;
import com.xdja.platform.microservice.db.druid.DruidPlugin;
import com.xdja.platform.microservice.kit.StrKit;
import com.xdja.platform.microservice.kit.prop.Prop;
import com.xdja.platform.microservice.kit.prop.PropKit;
import com.xdja.platform.microservice.plugin.IPlugin;
import com.xdja.platform.microservice.plugin.Plugins;
import com.xdja.platform.microservice.spring.SpringPlugin;
import com.xdja.platform.rpc.provider.ProviderStarter;
import com.xdja.platform.rpc.proxy.PagingConverter;
import java.net.BindException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class RASConfig
extends MicroServiceConfig {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String IP = "127.0.0.1";
    private static final int PORT = 6666;
    private static final int MAXWORKTHREAD = 100;

    public void configPlugin(Plugins me) {
        Prop prop = PropKit.use((String)"db.properties");
        String url = prop.get("jdbcUrl");
        if (StrKit.isBlank((String)url)) {
            throw ServiceException.create((String)"\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6db.properties\u4e2d\u6dfb\u52a0jdbcUrl\u7684\u914d\u7f6e", null);
        }
        String userName = prop.get("userName");
        if (StrKit.isBlank((String)userName)) {
            throw ServiceException.create((String)"\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6db.properties\u4e2d\u6dfb\u52a0userName\u7684\u914d\u7f6e", null);
        }
        String password = prop.get("password");
        DruidPlugin dbPlugin = new DruidPlugin(url, userName, password);
        me.add((IPlugin)dbPlugin);
        DbUtilsPlugin daoPlugin = new DbUtilsPlugin("RAS", (DataSourceProvider)dbPlugin);
        me.add((IPlugin)daoPlugin);
        String[] configLocations = new String[]{"classpath*:/META-INF/spring/applicationContext-*.xml", "classpath*:/applicationContext.xml"};
        me.add((IPlugin)new SpringPlugin((ApplicationContext)new ClassPathXmlApplicationContext(configLocations)));
    }

    public void afterStart() {
        PagingConverter.pageNoMethodName = "getPageNumber";
        PagingConverter.pageSizeMethodName = "getPageSize";
        PagingConverter.totalCountMethodName = "getRecordCount";
        PagingConverter.totalPageMethodName = "getPageCount";
        PagingConverter.dataListMethodName = "getList";
        Prop prop = PropKit.use((String)"service.properties");
        String ip = prop.get("ip", IP);
        int port = prop.getInt("port", Integer.valueOf(6666));
        int maxWorkThread = prop.getInt("maxWorkThread", Integer.valueOf(100));
        try {
            ProviderStarter.NETTY.setMaxWorkThread(maxWorkThread).start(ip, port);
            this.logger.debug("====>RAS\u670d\u52a1{}:{}\u542f\u52a8\u6210\u529f\uff0c\u6700\u5927\u5de5\u4f5c\u7ebf\u7a0b\u6570\u4e3a{}\u4e2a\uff01", new Object[]{ip, port, maxWorkThread});
        }
        catch (BindException e) {
            this.logger.error("\u670d\u52a1\u7ed1\u5b9a\u5f02\u5e38", (Object)e.getMessage());
        }
        catch (InterruptedException e) {
            this.logger.error("\u7ebf\u7a0b\u5f02\u5e38", (Object)e.getMessage());
        }
    }
}

