package com.xdja.eoa.facadeservice;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.ldy.splitbase.modulecommunication.facade.ModuleFacade;
import com.xdja.eoa.commonutil.LogUtils;
import java.util.HashMap;
import java.util.Map;

/**
 * Created  on 2019/10/23
 * @author zhuruyi
 */
public class FacadeServiceManager {
	public static final String TAG = FacadeServiceManager.class.getSimpleName();

	private Map<String, ModuleFacade> facadeCache;

	private FacadeServiceManager(){
		facadeCache = new HashMap<>();
	}

	private static class SingletonHolder {
		private static FacadeServiceManager INSTANCE = new FacadeServiceManager();
	}

	public static FacadeServiceManager getInstance() {
		return SingletonHolder.INSTANCE;
	}

	/**
	 * 注册服务
	 * @param facadeName {@link ServiceConstants}
	 * @param facade
	 */
	public void registerFacade(String facadeName, @NonNull ModuleFacade facade){
		if (facadeCache.containsKey(facadeName)) {
			LogUtils.i(TAG, facadeName + " already register!");
			return;
		}
		facadeCache.put(facadeName, facade);
	}

	/**
	 * 注销服务
	 * @param facadeName
	 */
	public void unRegisterFacade(@NonNull String facadeName){
		if (facadeCache.containsKey(facadeName)) {
			facadeCache.remove(facadeName);
			return;
		}
	}

	/**
	 * 获取服务
	 * @param facadeName
	 * @return 返回具体的服务，可能是null
	 */
	public @Nullable ModuleFacade getFacade(@NonNull String facadeName){
		if (facadeCache.containsKey(facadeName)) {
			return facadeCache.get(facadeName);
		}else {
			LogUtils.e(TAG, facadeName + " hasn't register!");
			return null;
		}
	}
}
