package com.xdja.eoa.facadeservice;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;

import com.ldy.splitbase.modulecommunication.facade.ModuleFacade;
import com.xdja.eoa.facadeservice.entity.PushResult;
import com.xdja.eoa.facadeservice.entity.office.ApprovalRoleSelectParams;
import com.xdja.eoa.facadeservice.entity.office.ApprovalRoleSelectedData;
import java.util.List;

/**
 * Created by ldy on 2017/6/19.
 */

public interface MainFacade extends ModuleFacade {
    void showNotification(PushResult pushResult);

    void showNotification(PushResult pushResult, int notificationId);

    void openWebPage(String url);

    void clearAllNotification();

    void clearNotification(int notifyId);

    boolean autoHandleTokenException(Throwable throwable, Context context);

    void signMsgReadStatus(PushResult pushData);

    /**
     * 减少应用消息数量
     *
     * @param appId              appId
     * @param removeAppNoticeNum 减少的消息数量，负数为加
     */
    void removeAppNoticeNum(long appId, int removeAppNoticeNum);

    /**
     * 退出登录(含有弹框)
     *
     * @param activitySource 界面上下文
     * @param msg            dialog提示信息
     */
    void exitLoginWithDialog(Activity activitySource, String msg);

    /**
     * 跳转到资讯详情页面
     *
     * @param sourceContext
     * @param detailUrl         资讯详情页面Url
     * @param title             资讯默认标题，传null则使用webview接收标题
     * @param isFavorite        显示收藏，true显示收藏，false显示取消收藏，默认true
     * @param posterImageUrl    封面图片链接
     * @param posterContentText 封面内容
     * @param favoriteId        收藏Id
     */
    void jump2H5WithShareActivity(@Nullable Context sourceContext, String detailUrl, String title, boolean isFavorite, String posterImageUrl, String posterContentText, long favoriteId);

    /**
     * 添加收藏
     *
     * @param type    收藏类型 1.链接 2.文本 3.图片 4.视频 5.文件
     * @param content 收藏内容
     * @param from    收藏来源
     */
    void addFavorite(int type, String content, String from);

    /**
     * 取消收藏
     *
     * @param id 收藏条目id
     */
    void removeFavorite(long id);

    /**
     * 打开审核-我发起的模块
     *
     * @param appId 审核模块appid
     */
    void startMyOriginate(Context ctx, int appId);

    void onQRLoginScanResult(String uid);

    /**
     * 启动选择审批角色、人员
     *
     * @param sourceFragment
     * @param selectParams
     */
    void startApproveRoleSelect4Result(Fragment sourceFragment, ApprovalRoleSelectParams selectParams, int requestCode);

    /**
     * 获取选择审批角色、人员数据结果
     *
     * @param intent
     * @return
     */
    List<ApprovalRoleSelectedData> getApproveSelectRole(Intent intent);
}
