package com.xdja.eoa.facadeservice.entity;

import android.support.annotation.IntDef;

import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * Created by hjl on 2017/6/8.
 */

public class PushBody implements Serializable {

    /**
     * @Fields serialVersionUID :
     */
    private static final long serialVersionUID = -5807210000179939251L;
    private int notify_type;////消息类型。0是通知类(与服务器没有直接的交互)，1是业务推拉(服务器有直接的交互)
    private String type_desc;////消息类型说明
    private int module_code;//模块代码
    private String module_desc;//模块描述
    private PushMessage message = new PushMessage();//
    private String extend;//扩展字段
    //zhangyq add 2017-6-8 14:05:36
    private String appId;//应用id
    private int appType;//1 本地  2 h5 3 apk,4 离线应用
    private String sn;
    private String appName;

    /**
     * 审批---子流程ID
     */
    private String subAppId;

    /**
     * 修补的扩展字段
     */
    private String fixedExtend;

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getSn() {
        return sn;
    }

    public void setSn(String sn) {
        this.sn = sn;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public int getNotify_type() {
        return notify_type;
    }

    public void setNotify_type(int notify_type) {
        this.notify_type = notify_type;
    }

    public String getType_desc() {
        return type_desc;
    }

    public void setType_desc(String type_desc) {
        this.type_desc = type_desc;
    }

    public int getModule_code() {
        return module_code;
    }

    public void setModule_code(int module_code) {
        this.module_code = module_code;
    }

    public String getModule_desc() {
        return module_desc;
    }

    public void setModule_desc(String module_desc) {
        this.module_desc = module_desc;
    }

    public PushMessage getMessage() {
        return message;
    }

    public void setMessage(PushMessage message) {
        this.message = message;
    }

    public String getExtend() {
        return extend;
    }

    public void setExtend(String extend) {
        this.extend = extend;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public int getAppType() {
        return appType;
    }

    public void setAppType(int appType) {
        this.appType = appType;
    }

    public String getSubAppId() {
        return subAppId;
    }

    public void setSubAppId(String subAppId) {
        this.subAppId = subAppId;
    }

    public String getFixedExtend() {
        return fixedExtend;
    }

    public void setFixedExtend(String fixedExtend) {
        this.fixedExtend = fixedExtend;
    }

    @Override
    public String toString() {
        return "PushBody{" +
                "notify_type=" + notify_type +
                ", type_desc='" + type_desc + '\'' +
                ", module_code=" + module_code +
                ", module_desc='" + module_desc + '\'' +
                ", message=" + message +
                ", extend='" + extend + '\'' +
                ", appId='" + appId + '\'' +
                ", appType=" + appType +
                ", sn='" + sn + '\'' +
                ", appName='" + appName + '\'' +
                '}';
    }

    public static class BusinessApp {

        @IntDef({TYPE_NATIVE,
                TYPE_H5,
                TYPE_APK,
                TYPE_H5_OFFLINE
        })
        @Retention(RetentionPolicy.SOURCE)

        public @interface type {
        }

        /**
         * 应用类型---本地应用
         */
        public static final int TYPE_NATIVE = 1;

        /**
         * 应用类型---H5在线应用
         */
        public static final int TYPE_H5 = 2;

        /**
         * 应用类型---Apk应用
         */
        public static final int TYPE_APK = 3;

        /**
         * 应用类型---离线应用
         */
        public static final int TYPE_H5_OFFLINE = 4;
    }
}
