package com.xdja.eoa.facadeservice.entity;

import android.support.annotation.IntDef;

import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * 推送报文
 *
 * @author hjl
 * @date 2017/4/22
 */

public class PushResult implements Serializable {

    /**
     * @Fields serialVersionUID :
     */
    private static final long serialVersionUID = -5309048036286835557L;

    private int notify_origin;//0是系统，应用层面  1是用户业务

    private String origin_desc;//"用户",//推送消息来源说明

    private String notify_order;//推送消息序列号

    private Long time;//时间戳

    private
    @Business.type
    int pushBusinessType;//推送业务类型( 1 oa框架自身  2 通讯录  3 im 4 办公九宫格 5 rss)

    private PushBody notify_body;

    public int getNotify_origin() {
        return notify_origin;
    }

    public void setNotify_origin(int notify_origin) {
        this.notify_origin = notify_origin;
    }

    public String getOrigin_desc() {
        return origin_desc;
    }

    public void setOrigin_desc(String origin_desc) {
        this.origin_desc = origin_desc;
    }

    public String getNotify_order() {
        return notify_order;
    }

    public void setNotify_order(String notify_order) {
        this.notify_order = notify_order;
    }

    public Long getTime() {
        return time;
    }

    public void setTime(Long time) {
        this.time = time;
    }

    public PushBody getNotify_body() {
        return notify_body;
    }

    public void setNotify_body(PushBody notify_body) {
        this.notify_body = notify_body;
    }

    public
    @Business.type
    int getPushBusinessType() {
        return pushBusinessType;
    }

    public void setPushBusinessType(@Business.type int pushBusinessType) {
        this.pushBusinessType = pushBusinessType;
    }

    @Override
    public String toString() {
        return "PushResult{" +
                "notify_origin=" + notify_origin +
                ", origin_desc='" + origin_desc + '\'' +
                ", notify_order='" + notify_order + '\'' +
                ", time=" + time +
                ", pushBusinessType=" + pushBusinessType +
                ", notify_body=" + notify_body +
                '}';
    }

    public static class Business {
        @IntDef({TYPE_ACCOUNT,
                TYPE_OA,
                TYPE_CONTACT,
                TYPE_IM,
                TYPE_OFFICE,
                TYPE_RSS,
                TYPE_MOMENTS,
                TYPE_CHAT_GROUP,
                TYPE_OFFICE_NOTICE,
                TYPE_OA_CHIPS_CHANGE
        })
        @Retention(RetentionPolicy.SOURCE)

        public @interface type {
        }

        /*账户*/
        public static final int TYPE_ACCOUNT = 0;

        /*OA框架*/
        public static final int TYPE_OA = 1;

        /*联系人*/
        public static final int TYPE_CONTACT = 2;

        /*聊天*/
        public static final int TYPE_IM = 3;

        /*办公*/
        public static final int TYPE_OFFICE = 4;

        /*资讯*/
        public static final int TYPE_RSS = 5;

        /*工作圈*/
        public static final int TYPE_MOMENTS = 6;

        /*群组*/
        public static final int TYPE_CHAT_GROUP = 7;

        /**
         * 办公应用 九宫格 角标
         */
        public static final int TYPE_OFFICE_NOTICE = 8;

        /**
         * 芯片绑定状态验证
         */
        public static final int TYPE_OA_CHIPS_CHANGE = 9;
        /*上面能用的尽量不要在加新的标识常量*/
    }
}
