package com.xdja.eoa.facadeservice.entity.office;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.List;

/**
 * @author wanjing
 * @date 2019/7/19
 * <p>
 * 自定义审批-选择角色/人员 搜索界面传入数据
 */
public class ApprovalRoleSelectParams implements Parcelable {

    /**
     * 审批角色、人员范围选择
     */
    public static final int SELECT_TYPE_APPROVE = 1;

    /**
     * 抄送角色、人员范围选择
     */
    public static final int SELECT_TYPE_COPY = 2;

    /**
     * 选择范围类型
     * {@link #SELECT_TYPE_APPROVE#SELECT_TYPE_COPY}
     */
    private int type;

    /**
     * 选择主界面标题title
     */
    private String selectTitle;

    /**
     * 子应用(子流程)id
     */
    private transient long appId;

    /**
     * 子流程应用 父应用Id
     */
    private transient long appParentId;

    /**
     * 流程节点id type==1时
     */
    private long flowNodeId;

    /**
     * 流程发起id type==2时
     */
    private long initiateId;

    /**
     * 1 待办 2我发起的 3抄送我的  4已办）type==2时
     */
    private int tab;

    /**
     * 一次最多可以选择多少人
     */
    private int maxLength;

    /**
     * 已选择人员/角色
     */
    private List<ApprovalRoleSelectedData> selectedData;

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getSelectTitle() {
        return selectTitle;
    }

    public void setSelectTitle(String selectTitle) {
        this.selectTitle = selectTitle;
    }

    public long getAppId() {
        return appId;
    }

    public void setAppId(long appId) {
        this.appId = appId;
    }

    public long getAppParentId() {
        return appParentId;
    }

    public void setAppParentId(long appParentId) {
        this.appParentId = appParentId;
    }

    public long getFlowNodeId() {
        return flowNodeId;
    }

    public void setFlowNodeId(long flowNodeId) {
        this.flowNodeId = flowNodeId;
    }

    public long getInitiateId() {
        return initiateId;
    }

    public void setInitiateId(long initiateId) {
        this.initiateId = initiateId;
    }

    public int getTab() {
        return tab;
    }

    public void setTab(int tab) {
        this.tab = tab;
    }

    public int getMaxLength() {
        return maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public List<ApprovalRoleSelectedData> getSelectedData() {
        return selectedData;
    }

    public void setSelectedData(List<ApprovalRoleSelectedData> selectedData) {
        this.selectedData = selectedData;
    }

    public ApprovalRoleSelectParams() {
    }

    protected ApprovalRoleSelectParams(Parcel in) {
        type = in.readInt();
        selectTitle = in.readString();
        appId = in.readLong();
        appParentId = in.readLong();
        flowNodeId = in.readLong();
        initiateId = in.readLong();
        tab = in.readInt();
        maxLength = in.readInt();
        selectedData = in.createTypedArrayList(ApprovalRoleSelectedData.CREATOR);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(type);
        dest.writeString(selectTitle);
        dest.writeLong(appId);
        dest.writeLong(appParentId);
        dest.writeLong(flowNodeId);
        dest.writeLong(initiateId);
        dest.writeInt(tab);
        dest.writeInt(maxLength);
        dest.writeTypedList(selectedData);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<ApprovalRoleSelectParams> CREATOR = new Creator<ApprovalRoleSelectParams>() {
        @Override
        public ApprovalRoleSelectParams createFromParcel(Parcel in) {
            return new ApprovalRoleSelectParams(in);
        }

        @Override
        public ApprovalRoleSelectParams[] newArray(int size) {
            return new ApprovalRoleSelectParams[size];
        }
    };
}
