package com.xdja.eoa.facadeservice.entity.office;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * @author wanjing
 * @date 2019/7/19
 * <p>
 * 自定义审批-选择角色/人员 请求参数
 */
public class ApprovalRoleSelectedData implements Parcelable {

    /**
     * 人员
     */
    public static final int TYPE_PERSON = 1;

    /**
     * 角色
     */
    public static final int TYPE_ROLE = 2;

    /**
     * 1:人员 2角色
     * {@link #TYPE_PERSON#TYPE_ROLE}
     */
    private int type;

    /**
     * 人员/角色id
     */
    private long id;

    /**
     * 人员/角色名称
     */
    private String name;

    /**
     * 企业名称 type==1时
     */
    private String companyName;

    /**
     * 人员头像 type==1时 group1/M00/04/B6/rBIAC1ytTcKEE5hHAAAAACvejS8829.png
     */
    private String avatar;

    /**
     * 人员头像 type==1时 base/getFile?fileid=group1/M00/04/B6/rBIAC1ytTcKEE5hHAAAAACvejS8829.png&perm=1
     */
    private String avatarUrl;

    /**
     * 角色中的人员总数 type==2时
     */
    private int roleEmployeeCount;

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getAvatarUrl() {
        return avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public int getRoleEmployeeCount() {
        return roleEmployeeCount;
    }

    public void setRoleEmployeeCount(int roleEmployeeCount) {
        this.roleEmployeeCount = roleEmployeeCount;
    }

    public ApprovalRoleSelectedData() {
    }

    protected ApprovalRoleSelectedData(Parcel in) {
        type = in.readInt();
        id = in.readLong();
        name = in.readString();
        companyName = in.readString();
        avatar = in.readString();
        avatarUrl = in.readString();
        roleEmployeeCount = in.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(type);
        dest.writeLong(id);
        dest.writeString(name);
        dest.writeString(companyName);
        dest.writeString(avatar);
        dest.writeString(avatarUrl);
        dest.writeInt(roleEmployeeCount);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<ApprovalRoleSelectedData> CREATOR = new Creator<ApprovalRoleSelectedData>() {
        @Override
        public ApprovalRoleSelectedData createFromParcel(Parcel in) {
            return new ApprovalRoleSelectedData(in);
        }

        @Override
        public ApprovalRoleSelectedData[] newArray(int size) {
            return new ApprovalRoleSelectedData[size];
        }
    };
}
