package com.xdja.location;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PixelFormat;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Environment;
import android.util.Base64;
import android.util.Log;

import com.blankj.utilcode.utils.FileUtils;
import com.blankj.utilcode.utils.LogUtils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;

/**
 * created on 2017/8/28.
 * author:wangkezhi
 * email:45436660@qq.com
 * summary:
 */

public class BitmapUtils {

    private static final int itemh = 360;
    private static final int itemw = 360;
    /**
     * 缩略图最大大小（Byte)
     */
    private static final int miniMapMaxSize = 8192;

    private static final int scaleSize = 100 * 1024;

    private static final String TAG = "Util";
    public static final int DIRECTION_LEFT = 0;
    public static final int DIRECTION_RIGHT = 1;
    public static final int DIRECTION_UP = 2;
    public static final int DIRECTION_DOWN = 3;

    /**
     * 读取旋转角度
     *
     * @param path
     * @return
     */
    public static int readPictureDegree(String path) {
        int degree = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(path);
            int orientation = exifInterface.getAttributeInt(
                    ExifInterface.TAG_ORIENTATION, -1);
            switch (orientation) {
                case ExifInterface.ORIENTATION_ROTATE_90:
                    degree = 90;
                    break;
                case ExifInterface.ORIENTATION_ROTATE_180:
                    degree = 180;
                    break;
                case ExifInterface.ORIENTATION_ROTATE_270:
                    degree = 270;
                    break;
                case ExifInterface.ORIENTATION_NORMAL:
                case ExifInterface.ORIENTATION_UNDEFINED:
                case -1:
                    degree = 0;
                    break;
                default:
                    break;
            }
        } catch (IOException e) {

            e.printStackTrace();
        }

        return degree;
    }

    /**
     * 旋转
     *
     * @param bm
     * @param orientationDegree
     * @return
     */
    public static Bitmap adjustPhotoRotation(Bitmap bm,
                                             final int orientationDegree) {
        Matrix m = new Matrix();
        m.setRotate(orientationDegree, (float) bm.getWidth() / 2,
                (float) bm.getHeight() / 2);
        float targetX, targetY;
        if (orientationDegree == 90) {
            targetX = bm.getHeight();
            targetY = 0;
        } else {
            targetX = bm.getHeight();
            targetY = bm.getWidth();
        }
        final float[] values = new float[9];
        m.getValues(values);
        float x1 = values[Matrix.MTRANS_X];
        float y1 = values[Matrix.MTRANS_Y];
        m.postTranslate(targetX - x1, targetY - y1);
        Bitmap bm1 = Bitmap.createBitmap(bm.getHeight(), bm.getWidth(),
                Bitmap.Config.ARGB_8888);
        Paint paint = new Paint();
        Canvas canvas = new Canvas(bm1);
        canvas.drawBitmap(bm, m, paint);
        bm.recycle();
        bm = null;
        return bm1;
    }

    public static String fileFolder = Environment.getExternalStorageDirectory()
            .getPath() + "/jingxin/cache/file_scale/";

    public static void startPhotoZoom(Uri uri, Activity context, int requestCode) {
        Intent intent = new Intent("com.android.camera.action.CROP");
        intent.setDataAndType(uri, "image/*");
        intent.putExtra("crop", "true");

        intent.putExtra("aspectX", 1);
        intent.putExtra("aspectY", 1);

        intent.putExtra("outputX", itemh);
        intent.putExtra("outputY", itemw);
        intent.putExtra("return-data", true);
        context.startActivityForResult(intent, requestCode);

    }

    /**
     * 1.5倍放大bitmap
     *
     * @param bitmap
     * @return
     */
    public static Bitmap big(Bitmap bitmap) {
        Matrix matrix = new Matrix();
        // 长和宽放大缩小的比例
        matrix.postScale(1.5f, 1.5f);
        return Bitmap.createBitmap(bitmap, 0, 0, bitmap.getWidth(),
                bitmap.getHeight(), matrix, true);
    }

    /**
     * 缩小bitmap
     *
     * @param bitmap
     * @return
     */
    public static Bitmap small(Bitmap bitmap, float scale) {
        Matrix matrix = new Matrix();
        // 长和宽放大缩小的比例
        matrix.postScale(scale, scale);
        return Bitmap.createBitmap(bitmap, 0, 0, bitmap.getWidth(),
                bitmap.getHeight(), matrix, true);
    }

    /**
     * byte[]转Bitmap
     *
     * @param b byte数组
     * @return Bitmap
     */
    public static Bitmap Bytes2Bimap(byte[] b) {
        if (b.length != 0) {
            return BitmapFactory.decodeByteArray(b, 0, b.length);
        } else {
            return null;
        }
    }

    /**
     * Bitmap转byte[]
     *
     * @param bm Bitmap
     * @return byte[]
     */
    public static byte[] Bitmap2Bytes(Bitmap bm) {
        return Bitmap2Bytes(bm, 100);
    }

    /**
     * Bitmap转byte[]
     *
     * @param bm Bitmap
     * @return byte[]
     */
    public static byte[] Bitmap2Bytes(Bitmap bm, int level) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bm.compress(Bitmap.CompressFormat.JPEG, level, baos);
        return baos.toByteArray();
    }

    /**
     * 获取压缩后的图片
     */
    public static Bitmap getZoomedDrawable(String filePath, int zoom) {

        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile(filePath, options);
        int mWidth = options.outWidth;
        int mHeight = options.outHeight;
        int s = 1;
        while ((mWidth / s > itemw * 2 * zoom)
                || (mHeight / s > itemh * 2 * zoom)) {
            s *= 2;
        }

        options = new BitmapFactory.Options();
        options.inSampleSize = s;
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        options.inJustDecodeBounds = false;
        Bitmap bm = BitmapFactory.decodeFile(filePath, options);

        if (bm != null) {
            int h = bm.getHeight();
            int w = bm.getWidth();

            float ft = (float) w / (float) h;
            float fs = (float) itemw / (float) itemh;

            int neww = ft >= fs ? itemw * zoom : (int) (itemh * zoom * ft);
            int newh = ft >= fs ? (int) (itemw * zoom / ft) : itemh * zoom;

            float scaleWidth = ((float) neww) / w;
            float scaleHeight = ((float) newh) / h;

            Matrix matrix = new Matrix();
            matrix.postScale(scaleWidth, scaleHeight);
            bm = Bitmap.createBitmap(bm, 0, 0, w, h, matrix, true);
            return bm;
        }
        return null;
    }

    /**
     * * 获取圆形图片方法
     *
     * @param bitmap
     * @return Bitmap
     */
    public static Bitmap getCircleBitmap(Bitmap bitmap) {
        Bitmap output = Bitmap.createBitmap(bitmap.getWidth(),
                bitmap.getHeight(), Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        final int color = 0xff424242;
        final Paint paint = new Paint();
        final Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(color);
        int x = bitmap.getWidth();

        canvas.drawCircle(x / 2, x / 2, x / 2, paint);
        paint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        return output;
    }

    /**
     * 按照图片大小载入图片
     *
     * @param path  文件路径
     * @param width 最多宽度
     * @param heigh 最大高度
     * @return 图片信息
     */
    public static Bitmap getBitmap(String path, int width, int heigh) {
        if (!FileUtils.isFileExists(path)) {
            return null;
        }
        Bitmap bt = null;
        BitmapFactory.Options op = new BitmapFactory.Options();

        try {
            if (!path.contains("scale")) {
                op.inJustDecodeBounds = true;
                bt = BitmapFactory.decodeFile(path, op);
                int xScale = op.outWidth / width;
                int yScale = op.outHeight / heigh;
                op.inSampleSize = xScale > yScale ? xScale : yScale;
                op.inJustDecodeBounds = false;
                bt = BitmapFactory.decodeFile(path, op);
            } else {//针对已经压缩过的图片，直接缩放，这样不会导致质量受损
                op.inJustDecodeBounds = false;
                Bitmap bitmap = BitmapFactory.decodeFile(path, op);
                op.inJustDecodeBounds = true;
                bt = BitmapFactory.decodeFile(path, op);
                int xScale = op.outWidth / width;
                int yScale = op.outHeight / heigh;
                int scaleFactor = xScale > yScale ? xScale : yScale;

                bt = Bitmap.createScaledBitmap(bitmap, op.outWidth / scaleFactor, op.outHeight / scaleFactor, false);
            }

            if (null != bt) {
                Log.i("renjw", "miniMap size = " + bt.getByteCount());
            }

            return bt;
        } catch (Exception e) {
            if (e != null) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static String getBitmapBase64Str(Bitmap miniMap) {
        String miniMapStrByBase64 = "";
        // 当前压缩比
        int curCompressLevel = 100;
        //bengin add by renjw at 2015/12/21 16:52
        if (null == miniMap) {
            return "";
        }
        //end add by renjw at 2015/12/21 16:52
        byte[] curMiniMapBytes = Bitmap2Bytes(miniMap, curCompressLevel);
        if (curMiniMapBytes.length > miniMapMaxSize) {
            // 上一次压缩之后的大小
            byte[] lastMiniMapBytes = curMiniMapBytes;
            byte[] lastButOneMiniMapBytes = null;
            // 最大压缩比
            int maxCompressLevel = 99;
            // 最小压缩比
            int minCompressLevel = 1;
            // 上一次的压缩比
            int lastCompressLevel = curCompressLevel;
            int tempCompressLevel = 0;
            curCompressLevel = 100 - miniMapMaxSize * 100 / curMiniMapBytes.length;
            curCompressLevel = curCompressLevel == lastCompressLevel ? curCompressLevel - 1 : curCompressLevel;
            // 当前压缩之后的大小
            curMiniMapBytes = Bitmap2Bytes(miniMap, curCompressLevel);
            // 如果当前压缩比例与上次压缩比例不相等并且不相临
            while (Math.abs(curCompressLevel - lastCompressLevel) > 1 && curMiniMapBytes.length != miniMapMaxSize) {
                // 首先将原来缩略图赋值给临时存放变量，将原来的缩略图赋值为当前的缩略图
                lastButOneMiniMapBytes = lastMiniMapBytes;
                lastMiniMapBytes = curMiniMapBytes;

                tempCompressLevel = curCompressLevel;
                if (curMiniMapBytes.length > miniMapMaxSize) {
                    maxCompressLevel = curCompressLevel;
                    if (curCompressLevel > lastCompressLevel) {
                        curCompressLevel = curCompressLevel - (curCompressLevel - lastCompressLevel) / 2;
                    } else {
                        curCompressLevel = minCompressLevel + (curCompressLevel - minCompressLevel) / 2;
                    }
                } else {
                    minCompressLevel = curCompressLevel;
                    if (curCompressLevel > lastCompressLevel) {
                        curCompressLevel = maxCompressLevel - (maxCompressLevel - curCompressLevel) / 2;
                    } else {
                        curCompressLevel = curCompressLevel + (lastCompressLevel - curCompressLevel) / 2;
                    }
                }
                lastCompressLevel = tempCompressLevel;

                if (curCompressLevel != lastCompressLevel) {
                    curMiniMapBytes = Bitmap2Bytes(miniMap, curCompressLevel);
                }
            }

            // 如果当前一次压缩和上一次压缩都大于目标最大值，结果是上一次的前一次压缩
            if (curMiniMapBytes.length > miniMapMaxSize && lastMiniMapBytes.length > miniMapMaxSize) {
                //begin mod by renjw at 2016/3/30 20:15
                //防止空指针
                if (null != lastButOneMiniMapBytes) {
                    miniMapStrByBase64 = Base64.encodeToString(lastButOneMiniMapBytes, Base64.NO_WRAP);
                } else {
                    miniMapStrByBase64 = Base64.encodeToString(curMiniMapBytes, Base64.DEFAULT);
                }
                //end mod by renjw at 2016/3/30 20:15
            }

            //如果当前一次压缩和上一次压缩都小于目标最大值，证明上一次的前一次大于目标最大值，并且当前一次大于上一次，结果去当前一次
            else if (curMiniMapBytes.length < miniMapMaxSize && lastMiniMapBytes.length < miniMapMaxSize) {
                miniMapStrByBase64 = Base64.encodeToString(curMiniMapBytes, Base64.NO_WRAP);
            } else {
                //如果当前一次和上一次分别在目标最大值的两侧，取比目标最大值小的那个
                if (curMiniMapBytes.length > miniMapMaxSize) {
                    miniMapStrByBase64 = Base64.encodeToString(lastMiniMapBytes, Base64.NO_WRAP);
                } else {
                    miniMapStrByBase64 = Base64.encodeToString(curMiniMapBytes, Base64.NO_WRAP);
                }
            }

            lastMiniMapBytes = null;
            lastButOneMiniMapBytes = null;
        } else {
            miniMapStrByBase64 = Base64.encodeToString(curMiniMapBytes, Base64.DEFAULT);
        }

        curMiniMapBytes = null;
        LogUtils.e("sendPicture", System.currentTimeMillis() + "图片缩略图结束");
        return miniMapStrByBase64;
    }

    /**
     * 2014-05-17 11:04:07 xrj 添加缩略图
     *
     * @param pictureFilePath
     * @return
     */
    public static String getMiniMap(String pictureFilePath) {
        LogUtils.e("sendPicture", System.currentTimeMillis() + "图片缩略图开始");
        Bitmap miniMap = getBitmap(pictureFilePath, itemw, itemh);
        if (miniMap == null) {
            return "";
        }

        return getBitmapBase64Str(miniMap);
    }

    public static String getMiniMap2(Bitmap scaleBitmap) {
        LogUtils.e("sendPicture", System.currentTimeMillis() + "图片缩略图开始");
        if (scaleBitmap == null) {
            return "";
        }

        int xScale = scaleBitmap.getWidth() / itemw;
        int yScale = scaleBitmap.getHeight() / itemh;
        int scaleFactor = xScale > yScale ? xScale : yScale;

        if (scaleFactor <= 0) {
            scaleFactor = 1;
        }

        scaleBitmap = Bitmap.createScaledBitmap(scaleBitmap, scaleBitmap.getWidth() / scaleFactor, scaleBitmap.getHeight() / scaleFactor, false);

        return getBitmapBase64Str(scaleBitmap);
    }


    public static String saveMyBitmapWithCompress(String sourcePath, String destPath, Bitmap mBitmap, int compress) {
        String newFileName = System.currentTimeMillis() + new Random().nextInt(512) + ".png";
        File file = new File(destPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        File f = new File(destPath + "/" + newFileName);
        try {
            f.createNewFile();
            FileOutputStream fOut = new FileOutputStream(f);
            mBitmap.compress(Bitmap.CompressFormat.JPEG, compress, fOut);
            fOut.flush();
            fOut.close();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
            return sourcePath;
        } catch (IOException e) {
            e.printStackTrace();
            return sourcePath;
        }
        return destPath + "/" + newFileName;
    }

    public static Bitmap drawableToBitmap(Drawable drawable) {
        // 取drawable的长宽
        int width = drawable.getIntrinsicWidth();
        int height = drawable.getIntrinsicHeight();
        // 取drawable的颜色格式
        Bitmap.Config config = drawable.getOpacity() != PixelFormat.OPAQUE
                ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
        // 建立对应bitmap
        Bitmap bitmap = Bitmap.createBitmap(width, height, config);
        // 建立对应bitmap的画布
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, width, height);
        // 把drawable内容画到画布中
        drawable.draw(canvas);
        return bitmap;
    }

    public static void saveBitmap(Bitmap bitmap) {
        File file = new File(Environment.getExternalStorageDirectory().getPath() + "/mob/");
        if (!file.exists()) {
            file.mkdirs();
        }

        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(new File(file.getAbsolutePath(),
                    System.currentTimeMillis() + ".png"));
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, outputStream);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } finally {
            try {
                if (outputStream != null) {
                    outputStream.flush();
                    outputStream.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Bitmap getImageFromAssets(Context context, String fileName) {
        Bitmap image = null;
        AssetManager am = context.getResources().getAssets();
        InputStream is = null;
        try {
            is = am.open(fileName);
            image = BitmapFactory.decodeStream(is);
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                if (is != null) {
                    is.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return image;
    }
}
