package com.xdja.location;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;

import com.amap.api.location.AMapLocation;
import com.amap.api.location.AMapLocationClient;
import com.amap.api.location.AMapLocationClientOption;
import com.amap.api.location.AMapLocationListener;

/**
 * <b>Description: </b>
 * Created by <a href="mailto:syl@xdja.com">syl</a> on 2017/8/14.
 */

public class GaodeMapUtil {
    private AMapLocationClient mLocationClient;
    private AMapLocationClientOption mLocationOption;
    public static final String LOCATION_RESULT_CODE = "location_result_code";

    public GaodeMapUtil(Context context, final Handler handler) {
        mLocationClient = new AMapLocationClient(context);
        mLocationClient.setLocationListener(new AMapLocationListener() {
            @Override
            public void onLocationChanged(AMapLocation amapLocation) {
                if (amapLocation != null) {
                    Message message = new Message();
                    Bundle locationData = new Bundle();
                    locationData.putInt(LOCATION_RESULT_CODE, amapLocation.getErrorCode());
                    if (amapLocation.getErrorCode() == 0) {
                        //定位成功回调信息，设置相关消息
                        locationData.putString(LocationActivity.ADDRESS, amapLocation.getPoiName());
                        locationData.putString(LocationActivity.ADDRESS_DETAIL, amapLocation.getAddress());
                        locationData.putDouble(LocationActivity.LATITUDE, amapLocation.getLatitude());
                        locationData.putDouble(LocationActivity.LONGITUDE, amapLocation.getLongitude());
                    } else {
                        //显示错误信息ErrCode是错误码，errInfo是错误信息，详见错误码表。
                        Log.e("location", "AmapError location Error, ErrCode:"
                                + amapLocation.getErrorCode() + ", errInfo:"
                                + amapLocation.getErrorInfo());
                    }
                    message.setData(locationData);
                    handler.sendMessage(message);
                    Log.i("location", amapLocation.getAddress());
                    //停止定位
                    mLocationClient.stopLocation();
                    //销毁定位
                    mLocationClient.onDestroy();
                }
            }
        });
        //初始化定位参数
        mLocationOption = new AMapLocationClientOption();
        //设置定位模式为高精度模式，Battery_Saving为低功耗模式，Device_Sensors是仅设备模式
        mLocationOption.setLocationMode(AMapLocationClientOption.AMapLocationMode.Hight_Accuracy);
        //设置是否返回地址信息（默认返回地址信息）
        mLocationOption.setNeedAddress(true);
        //设置是否只定位一次,默认为false
        mLocationOption.setOnceLocation(true);
        //设置是否强制刷新WIFI，默认为强制刷新
        mLocationOption.setWifiActiveScan(true);
        //设置是否允许模拟位置,默认为false，不允许模拟位置
        mLocationOption.setMockEnable(false);
        //设置定位间隔,单位毫秒,默认为2000ms
        mLocationOption.setInterval(2000);
        //给定位客户端对象设置定位参数
        mLocationClient.setLocationOption(mLocationOption);
        //启动定位
        mLocationClient.startLocation();
    }
}
