package com.xdja.location;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;

/**
 * @author mob-wan
 * @date 2019/11/4
 * <p>
 * 监听Gps开关
 */
public class GpsSwitchObserver {

    private Context mContext;
    private OnGpsSwitchObserver mOnGpsSwitchObserver;

    private Receiver mReceiver;
    private String GPS_ACTION = "android.location.PROVIDERS_CHANGED";

    public GpsSwitchObserver(Context context, OnGpsSwitchObserver onGpsSwitchObserver) {
        this.mContext = context;
        this.mOnGpsSwitchObserver = onGpsSwitchObserver;

        observeGpsSwitch();
    }

    private void observeGpsSwitch() {
        IntentFilter filter = new IntentFilter();
        filter.addAction(GPS_ACTION);
        mReceiver = new Receiver();
        mContext.registerReceiver(mReceiver, filter);
    }

    /**
     * 释放资源
     */
    public void onDestroy() {
        if (mReceiver != null) {
            mContext.unregisterReceiver(mReceiver);
        }
        if (mContext != null) {
            mContext = null;
        }
    }


    class Receiver extends BroadcastReceiver {

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action == null) {
                return;
            }
            if (action.matches(GPS_ACTION)) {
                if (mOnGpsSwitchObserver != null) {
                    mOnGpsSwitchObserver.onGpsSwitch();
                }
            }
        }
    }

    public interface OnGpsSwitchObserver {

        void onGpsSwitch();
    }
}
