package com.xdja.location.params;

import android.os.Parcel;
import android.os.Parcelable;

public class LocationDetailParams implements Parcelable {
    private double latitude;
    private double longitude;
    private String desc;
    private int type;//1 百度2 高德 3 google 4 gis 5 其他
    /**是否启用我的位置,启用后会自动定位到当前所在位置,如果有指定经纬度,会显示两个点,并且默认是定位到当前的位置上*/
    private boolean isMyLocationEnable = true;
    public LocationDetailParams() {
    }

    public double getLatitude() {
        return latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isMyLocationEnable() {
        return isMyLocationEnable;
    }

    public void setMyLocationEnable(boolean myLocationEnable) {
        isMyLocationEnable = myLocationEnable;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeDouble(this.latitude);
        dest.writeDouble(this.longitude);
        dest.writeString(this.desc);
        dest.writeInt(this.type);
        dest.writeByte(this.isMyLocationEnable ? (byte) 1 : (byte) 0);
    }

    protected LocationDetailParams(Parcel in) {
        this.latitude = in.readDouble();
        this.longitude = in.readDouble();
        this.desc = in.readString();
        this.type = in.readInt();
        this.isMyLocationEnable = in.readByte() != 0;
    }

    public static final Creator<LocationDetailParams> CREATOR = new Creator<LocationDetailParams>() {
        @Override
        public LocationDetailParams createFromParcel(Parcel source) {
            return new LocationDetailParams(source);
        }

        @Override
        public LocationDetailParams[] newArray(int size) {
            return new LocationDetailParams[size];
        }
    };
}
