/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.eoa.sdk.module;

import android.content.Context;
import android.util.ArrayMap;
import com.alibaba.fastjson.JSON;
import com.xdja.eoa.sdk.SdkLog;
import com.xdja.eoa.sdk.cb.ICallbackListener;
import com.xdja.eoa.sdk.data.AppInfo;
import com.xdja.eoa.sdk.data.SynHelper;
import com.xdja.eoa.sdk.data.param.ApiAccessConfigParam;
import com.xdja.eoa.sdk.data.param.AppStartParams;
import com.xdja.eoa.sdk.data.param.LocationDetailWithRangeStartParams;
import com.xdja.eoa.sdk.data.result.AccountInfoResult;
import com.xdja.eoa.sdk.data.result.AuthCodeResult;
import com.xdja.eoa.sdk.module.IModuleApplication;
import com.xdja.eoa.sdk.module.IModuleFacade;
import com.xdja.eoa.sdk.module.IModuleSdkFacade;
import com.xdja.eoa.sdk.module.MethodParam;
import java.util.concurrent.CountDownLatch;

public class EoaModuleSdk {
    private ArrayMap<String, IModuleFacade> facadeCache = new ArrayMap();

    private EoaModuleSdk() {
    }

    public static EoaModuleSdk getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public IModuleSdkFacade getSdkFacade() {
        IModuleFacade moduleFacade = this.getFacade("facade_sdk");
        if (moduleFacade == null) {
            SdkLog.w("getSdkFacade--->facade_sdk is not registered");
            return null;
        }
        return (IModuleSdkFacade)moduleFacade;
    }

    public void registerFacade(String facadeName, IModuleFacade facade) {
        if (this.facadeCache.containsKey((Object)facadeName)) {
            SdkLog.w("registerFacade--->" + facadeName + " already register!");
            return;
        }
        this.facadeCache.put((Object)facadeName, (Object)facade);
    }

    public IModuleFacade getFacade(String facadeName) {
        if (this.facadeCache.containsKey((Object)facadeName)) {
            return (IModuleFacade)this.facadeCache.get((Object)facadeName);
        }
        SdkLog.e("getFacade--->" + facadeName + " is not registered");
        return null;
    }

    public static AuthCodeResult getAuthCode(Context context, Class<? extends IModuleApplication> moduleClass) {
        MethodParam methodParam = new MethodParam.Builder(moduleClass).setMethod("getAuthCode").create();
        final SynHelper synHelper = new SynHelper();
        EoaModuleSdk.getInstance().getSdkFacade().call(context, methodParam, new ICallbackListener(){

            @Override
            public void onCallBackResult(int errorCode, String data, String errorMsg, String mark) {
                if (errorCode == 0) {
                    AuthCodeResult codeResult = (AuthCodeResult)JSON.parseObject((String)data, AuthCodeResult.class);
                    synHelper.setSynData(codeResult);
                }
            }
        });
        return (AuthCodeResult)synHelper.getSynData();
    }

    public static void configApiAccess(Context context, Class<? extends IModuleApplication> moduleClass, ApiAccessConfigParam configParam, ICallbackListener listener) {
        String params = "";
        try {
            params = JSON.toJSONString((Object)configParam);
        }
        catch (Exception e) {
            SdkLog.w(e);
        }
        MethodParam methodParam = new MethodParam.Builder(moduleClass).setMethod("apiAccessConfig").setParams(params).create();
        EoaModuleSdk.getInstance().getSdkFacade().call(context, methodParam, listener);
    }

    public static synchronized AccountInfoResult getCurrentAccountInfo(Context context, Class<? extends IModuleApplication> moduleClass) {
        MethodParam methodParam = new MethodParam.Builder(moduleClass).setMethod("getAccountInfo").create();
        final SynHelper synHelper = new SynHelper();
        EoaModuleSdk.getInstance().getSdkFacade().call(context, methodParam, new ICallbackListener(){

            @Override
            public void onCallBackResult(int errorCode, String data, String errorMsg, String mark) {
                AccountInfoResult accountInfoResult = null;
                if (errorCode == 0) {
                    try {
                        accountInfoResult = (AccountInfoResult)JSON.parseObject((String)data, AccountInfoResult.class);
                    }
                    catch (Exception e) {
                        SdkLog.w(e);
                    }
                    synHelper.setSynData(accountInfoResult);
                }
            }
        });
        return (AccountInfoResult)synHelper.getSynData();
    }

    public static void startApp(Context context, Class<? extends IModuleApplication> moduleClass, AppStartParams startParams) {
        String param = "";
        try {
            param = JSON.toJSONString((Object)startParams);
        }
        catch (Exception e) {
            SdkLog.w(e);
        }
        MethodParam methodParam = new MethodParam.Builder(moduleClass).setMethod("startApp").setParams(param).create();
        EoaModuleSdk.getInstance().getSdkFacade().call(context, methodParam, null);
    }

    public static void openLocationDetailWithRange(Context context, Class<? extends IModuleApplication> moduleClass, LocationDetailWithRangeStartParams startParams) {
        String params = "";
        try {
            params = JSON.toJSONString((Object)startParams);
        }
        catch (Exception e) {
            SdkLog.w(e);
        }
        MethodParam methodParam = new MethodParam.Builder(moduleClass).setMethod("startLocationDetailWithRange").setParams(params).create();
        EoaModuleSdk.getInstance().getSdkFacade().call(context, methodParam, null);
    }

    public static AppInfo getAppInfo(Context context, Class<? extends IModuleApplication> moduleClass) {
        MethodParam methodParam = new MethodParam.Builder(moduleClass).setMethod("getAppInfo").create();
        final SynHelper synHelper = new SynHelper();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        EoaModuleSdk.getInstance().getSdkFacade().call(context, methodParam, new ICallbackListener(){

            @Override
            public void onCallBackResult(int errorCode, String data, String errorMsg, String mark) {
                AppInfo appInfo = null;
                if (0 == errorCode) {
                    try {
                        appInfo = (AppInfo)JSON.parseObject((String)data, AppInfo.class);
                    }
                    catch (Exception e) {
                        SdkLog.w(e);
                    }
                }
                synHelper.setSynData(appInfo);
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            SdkLog.w(e);
        }
        return (AppInfo)synHelper.getSynData();
    }

    private static class SingletonHolder {
        private static EoaModuleSdk INSTANCE = new EoaModuleSdk();

        private SingletonHolder() {
        }
    }
}

