/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.filetransfer.bean;

import com.xdja.filetransfer.bean.Step;
import com.xdja.filetransfer.enums.OperateEnum;
import java.util.ArrayList;
import java.util.List;

public class OperateParam {
    private List<Step> steps;

    public OperateParam(List<Step> steps) {
        this.steps = steps;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public void setSteps(List<Step> steps) {
        this.steps = steps;
    }

    public void addStep(Step step) {
        if (this.steps == null) {
            this.steps = new ArrayList<Step>();
        }
        this.steps.add(step);
    }

    public static OperateParam create() {
        return new OperateParam(new ArrayList<Step>());
    }

    public static OperateParam create(List<Step> steps) {
        return new OperateParam(steps);
    }

    public OperateParam deleteCommentStep() {
        this.addStep(new Step(OperateEnum.DELETECOMMENTS.getOperate(), null));
        return this;
    }

    public OperateParam acceptRevisionsStep() {
        this.addStep(new Step(OperateEnum.ACCEPTREVISIONS.getOperate(), null));
        return this;
    }

    public OperateParam convertToPDFStep() {
        this.addStep(new Step(OperateEnum.CONVERTTOPDF.getOperate(), null));
        return this;
    }

    public OperateParam convertToTXTStep() {
        this.addStep(new Step(OperateEnum.CONVERTTOTXT.getOperate(), null));
        return this;
    }

    public OperateParam trackRevisionsStep() {
        this.addStep(new Step(OperateEnum.TRACKREVISIONS.getOperate(), null));
        return this;
    }

    public OperateParam cleanStep() {
        this.addStep(new Step(OperateEnum.CLEAN.getOperate(), null));
        return this;
    }

    public OperateParam mergePdfStep() {
        this.addStep(new Step(OperateEnum.MERGEPDF.getOperate(), null));
        return this;
    }

    public OperateParam exportStep() {
        this.addStep(new Step(OperateEnum.EXPORT.getOperate(), null));
        return this;
    }

    public OperateParam save() {
        this.addStep(new Step(OperateEnum.SAVE.getOperate(), null));
        return this;
    }
}

