/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.filetransfer.core.future;

import com.xdja.filetransfer.bean.FileBean;
import com.xdja.filetransfer.bean.OperateResult;
import com.xdja.filetransfer.bean.WaterMarkBean;
import com.xdja.filetransfer.core.FileTransferFactory;
import com.xdja.filetransfer.core.TransferInterface;
import com.xdja.filetransfer.core.task.MultiTransferFileTask;
import com.xdja.filetransfer.core.task.TransferFileByBytesTask;
import com.xdja.filetransfer.core.task.TransferFileByJsonTask;
import com.xdja.filetransfer.enums.FileExtensionEnum;
import com.xdja.filetransfer.enums.OperateEnum;
import com.xdja.filetransfer.enums.TypeEnum;
import com.xdja.filetransfer.util.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FutureFactory {
    private String address;
    private String appId;
    private String appSecret;

    public FutureFactory(String address, String appId, String appSecret) {
        this.address = address;
        this.appId = appId;
        this.appSecret = appSecret;
    }

    public FutureTask<byte[]> createTask(String fileId, TypeEnum type, FileExtensionEnum fileExtensionEnum, String fileAddress, OperateEnum ... operateEnums) {
        return new FutureTask<byte[]>(new TransferFileByJsonTask(fileId, fileExtensionEnum, fileAddress, this.address, type, this.appId, this.appSecret, operateEnums));
    }

    public FutureTask<byte[]> createTask(String fileId, FileExtensionEnum fileExtensionEnum, byte[] file, TypeEnum type, OperateEnum ... operateEnums) {
        return new FutureTask<byte[]>(new TransferFileByBytesTask(fileId, fileExtensionEnum, file, this.address, type, this.appId, this.appSecret, operateEnums));
    }

    public FutureTask<byte[]> createTask(String fileId, FileExtensionEnum fileExtensionEnum, File file, TypeEnum type, OperateEnum ... operateEnums) {
        return new FutureTask<byte[]>(new TransferFileByBytesTask(fileId, fileExtensionEnum, FileUtil.getBytesByFile(file), this.address, type, this.appId, this.appSecret, operateEnums));
    }

    public FutureTask<byte[]> createTask(String fileId, FileExtensionEnum fileExtensionEnum, InputStream inputStream, TypeEnum type, OperateEnum ... operateEnums) {
        return new FutureTask<byte[]>(new TransferFileByBytesTask(fileId, fileExtensionEnum, FileUtil.getBytesByInputStream(inputStream), this.address, type, this.appId, this.appSecret, operateEnums));
    }

    public FutureTask<List<OperateResult>> createTask(List<FileBean> fileBeans, WaterMarkBean waterMarkBean, OperateEnum ... operateEnums) {
        return new FutureTask<List<OperateResult>>(new MultiTransferFileTask(fileBeans, waterMarkBean, this.address, TypeEnum.WPSV2, this.appId, this.appSecret, operateEnums));
    }

    public void multiTransferFileCallBack(List<FileBean> files, WaterMarkBean waterMarkBean, String callbackUrl, OperateEnum ... operateEnums) {
        TransferInterface transferEngine = FileTransferFactory.getTransferEngine(TypeEnum.WPSV2);
        transferEngine.multiFileTransferCallBack(files, waterMarkBean, this.address, callbackUrl, this.appId, this.appSecret, operateEnums);
    }

    public void run(FutureTask futureTask) {
        h.executorService.submit(futureTask);
    }

    public <T> T get(FutureTask<T> futureTask) throws ExecutionException, InterruptedException, TimeoutException {
        return futureTask.get(100L, TimeUnit.SECONDS);
    }

    public <T> T get(FutureTask<T> futureTask, long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        return futureTask.get(timeout, unit);
    }

    public InputStream getInputStream(FutureTask<byte[]> futureTask) throws ExecutionException, InterruptedException, TimeoutException {
        byte[] bytes = futureTask.get(100L, TimeUnit.SECONDS);
        return new ByteArrayInputStream(bytes);
    }

    public InputStream getInputStream(FutureTask<byte[]> futureTask, long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        byte[] bytes = futureTask.get(timeout, unit);
        return new ByteArrayInputStream(bytes);
    }

    public void shutdown() {
        h.executorService.shutdown();
    }

    private static class h {
        private static ExecutorService executorService = Executors.newCachedThreadPool();

        private h() {
        }
    }
}

