/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.filetransfer.core.impl;

import com.alibaba.fastjson.JSON;
import com.xdja.filetransfer.bean.ConvertResult;
import com.xdja.filetransfer.bean.File;
import com.xdja.filetransfer.bean.FileBean;
import com.xdja.filetransfer.bean.FileResult;
import com.xdja.filetransfer.bean.ImageWater;
import com.xdja.filetransfer.bean.MultiOperateBean;
import com.xdja.filetransfer.bean.OpStep;
import com.xdja.filetransfer.bean.OperateBean;
import com.xdja.filetransfer.bean.OperateResult;
import com.xdja.filetransfer.bean.QueryResult;
import com.xdja.filetransfer.bean.SingleOperateBean;
import com.xdja.filetransfer.bean.WaterMarkBean;
import com.xdja.filetransfer.bean.Watermark;
import com.xdja.filetransfer.core.TransferInterface;
import com.xdja.filetransfer.enums.FileExtensionEnum;
import com.xdja.filetransfer.enums.OperateEnum;
import com.xdja.filetransfer.enums.OperateStatusEnum;
import com.xdja.filetransfer.exception.FileTransferException;
import com.xdja.filetransfer.util.SignatureUtil;
import com.xdja.framework.commons.utils.http.HttpUtils;
import com.xdja.framework.commons.utils.http.ResponseWrap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WpsFileTransferV2
implements TransferInterface {
    private final Logger log = LoggerFactory.getLogger(WpsFileTransferV2.class);
    private static final String DEFAULT_APPID = "123";

    private WpsFileTransferV2() {
    }

    public static WpsFileTransferV2 getInstance() {
        return Instance.instance;
    }

    @Override
    public byte[] fileTransfer(String fileId, String address, FileExtensionEnum extensionEnum, String fileAddress, String appId, String appSecret, OperateEnum ... operateEnums) {
        File file = this.createFile(fileId, extensionEnum.getFileExtension(), fileAddress);
        OperateBean operateBean = this.createOperateParam(Collections.singletonList(file), null, operateEnums);
        List<FileResult> fileResults = this.convertByRemoteFile(operateBean, address, appId, appSecret);
        if (fileResults != null && fileResults.size() > 0) {
            FileResult fileResult = fileResults.get(0);
            String downloadUrl = this.getDownloadUrl(fileResult);
            return this.getContent(downloadUrl);
        }
        throw new FileTransferException("\u8fdc\u7a0b\u6587\u4ef6\u65b9\u5f0f\u8f6c\u6362\u6587\u4ef6\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
    }

    @Override
    public String fileTransferAddress(String fileId, String address, FileExtensionEnum extensionEnum, String fileAddress, String appId, String appSecret, OperateEnum ... operateEnums) {
        File file = this.createFile(fileId, extensionEnum.getFileExtension(), fileAddress);
        OperateBean operateBean = this.createOperateParam(Collections.singletonList(file), null, operateEnums);
        List<FileResult> fileResults = this.convertByRemoteFile(operateBean, address, appId, appSecret);
        if (fileResults != null && fileResults.size() > 0) {
            FileResult fileResult = fileResults.get(0);
            return this.getDownloadUrl(fileResult);
        }
        throw new FileTransferException("\u8fdc\u7a0b\u6587\u4ef6\u65b9\u5f0f\u8f6c\u6362\u6587\u4ef6\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
    }

    @Override
    public byte[] fileTransfer(String fileId, String address, FileExtensionEnum extensionEnum, byte[] bytes, String appId, String appSecret, OperateEnum ... operateEnums) {
        File file = this.createFile(fileId, extensionEnum.getFileExtension(), null);
        OperateBean operateBean = this.createOperateParam(Collections.singletonList(file), null, operateEnums);
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        map.put(fileId, bytes);
        List<FileResult> fileResults = this.convertByLocalFile(operateBean, address, appId, "", map);
        if (fileResults != null && fileResults.size() > 0) {
            FileResult fileResult = fileResults.get(0);
            String downloadUrl = this.getDownloadUrl(fileResult);
            return this.getContent(downloadUrl);
        }
        throw new FileTransferException("\u672c\u5730\u6587\u4ef6\u65b9\u5f0f\u8f6c\u6362\u6587\u4ef6\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
    }

    @Override
    public String fileTransferAddress(String fileId, String address, FileExtensionEnum extensionEnum, byte[] bytes, String appId, String appSecret, OperateEnum ... operateEnums) {
        File file = this.createFile(fileId, extensionEnum.getFileExtension(), null);
        OperateBean operateBean = this.createOperateParam(Collections.singletonList(file), null, operateEnums);
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        map.put(fileId, bytes);
        List<FileResult> fileResults = this.convertByLocalFile(operateBean, address, appId, "", map);
        if (fileResults != null && fileResults.size() > 0) {
            FileResult fileResult = fileResults.get(0);
            return this.getDownloadUrl(fileResult);
        }
        throw new FileTransferException("\u672c\u5730\u6587\u4ef6\u65b9\u5f0f\u8f6c\u6362\u6587\u4ef6\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
    }

    @Override
    public List<OperateResult> multiFileTransfer(List<FileBean> files, WaterMarkBean waterMarkBean, String address, String appId, String appSecret, OperateEnum ... operateEnums) {
        if (files == null || files.size() <= 0) {
            throw new FileTransferException("\u8bf7\u6307\u5b9a\u8981\u8f6c\u6362\u7684\u6587\u4ef6\u4fe1\u606f");
        }
        ArrayList<File> fileList = new ArrayList<File>();
        Map<String, byte[]> map = this.getFileList(files, fileList, waterMarkBean);
        OperateBean operateBean = this.createOperateParam(fileList, waterMarkBean, operateEnums);
        List<FileResult> fileResults = map.keySet().size() <= 0 ? this.convertByRemoteFile(operateBean, address, appId, appSecret) : this.convertByLocalFile(operateBean, address, appId, appSecret, map);
        if (fileResults != null && fileResults.size() > 0) {
            return this.getMultiContent(fileResults);
        }
        throw new FileTransferException("\u672c\u5730\u6587\u4ef6\u65b9\u5f0f\u8f6c\u6362\u6587\u4ef6\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
    }

    @Override
    public void multiFileTransferCallBack(List<FileBean> files, WaterMarkBean waterMarkBean, String address, String callbackUrl, String appId, String appSecret, OperateEnum ... operateEnums) {
        if (files == null || files.size() <= 0) {
            throw new FileTransferException("\u8bf7\u6307\u5b9a\u8981\u8f6c\u6362\u7684\u6587\u4ef6\u4fe1\u606f");
        }
        ArrayList<File> fileList = new ArrayList<File>();
        String url = address + "/api/v2/cps/convert";
        if (StringUtils.isNotBlank((CharSequence)appId) && StringUtils.isNotBlank((CharSequence)appSecret)) {
            url = url + "?appid=" + appId + "&signature=" + "";
        }
        Map<String, byte[]> map = this.getFileList(files, fileList, waterMarkBean);
        OperateBean operateBean = this.createOperateParam(fileList, waterMarkBean, operateEnums);
        if (map.keySet().size() <= 0) {
            this.convertFileByRemoteFile(operateBean, url);
        } else {
            this.convertFileByLocalFile(operateBean, url, map);
        }
    }

    private Map<String, byte[]> getFileList(List<FileBean> fileBeans, List<File> files, WaterMarkBean waterMarkBean) {
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        for (FileBean fileBean : fileBeans) {
            File file = new File();
            if (StringUtils.isBlank((CharSequence)fileBean.getLocation())) {
                file.setSourceType(3);
                map.put(fileBean.getFileID(), fileBean.getBytes());
            } else {
                file.setSourceType(2);
                file.setLocation(fileBean.getLocation());
            }
            file.setFileID(fileBean.getFileID());
            file.setExt(fileBean.getExt());
            file.setArgs(fileBean.getArgs());
            file.setName(fileBean.getName());
            file.setPassword(fileBean.getPassword());
            file.setSize(fileBean.getSize());
            file.setVersion(fileBean.getVersion());
            files.add(file);
        }
        if (waterMarkBean != null && waterMarkBean.getImageBytes() != null && StringUtils.isNotBlank((CharSequence)waterMarkBean.getImageFileId())) {
            map.put(waterMarkBean.getImageFileId(), waterMarkBean.getImageBytes());
        }
        return map;
    }

    private File createFile(String fileId, String ext, String address) {
        File file = new File();
        file.setExt(ext);
        if (StringUtils.isNotBlank((CharSequence)address)) {
            file.setLocation(address);
            file.setSourceType(2);
        } else {
            file.setSourceType(3);
        }
        file.setFileID(fileId);
        return file;
    }

    private OperateBean createOperateParam(List<File> files, WaterMarkBean waterMarkBean, OperateEnum ... operateEnums) {
        if (operateEnums == null || operateEnums.length == 0) {
            SingleOperateBean singleOperateBean = new SingleOperateBean();
            singleOperateBean.setFileInfos(files);
            singleOperateBean.setConvertType(1);
            singleOperateBean.setPriority(1);
            return singleOperateBean;
        }
        MultiOperateBean multiOperateBean = new MultiOperateBean();
        multiOperateBean.setFileInfos(files);
        multiOperateBean.setPriority(1);
        ArrayList<OpStep> opSteps = new ArrayList<OpStep>();
        block8: for (OperateEnum operateEnum : operateEnums) {
            OpStep opStep = new OpStep();
            switch (operateEnum) {
                case DELETECOMMENTS: {
                    opStep.setOperate(OperateEnum.DELETECOMMENTS.getOperate());
                    opSteps.add(opStep);
                    continue block8;
                }
                case ACCEPTREVISIONS: {
                    opStep.setOperate("opRevisions");
                    HashMap<String, Integer> args = new HashMap<String, Integer>();
                    args.put("accept", 1);
                    opStep.setArgs(args);
                    opSteps.add(opStep);
                    continue block8;
                }
                case CONVERTTOPDF: {
                    opStep.setOperate("convert");
                    HashMap<String, Integer> args1 = new HashMap<String, Integer>();
                    args1.put("convertType", 1);
                    opStep.setArgs(args1);
                    opSteps.add(opStep);
                    continue block8;
                }
                case CONVERTTOTXT: {
                    opStep.setOperate("convert");
                    HashMap<String, Integer> args2 = new HashMap<String, Integer>();
                    args2.put("convertType", 2);
                    opStep.setArgs(args2);
                    opSteps.add(opStep);
                    continue block8;
                }
                case CONVERTTOPNG: {
                    opStep.setOperate("convert");
                    HashMap<String, Integer> args3 = new HashMap<String, Integer>();
                    args3.put("convertType", 3);
                    opStep.setArgs(args3);
                    continue block8;
                }
                case ADD_WATER_MASK: {
                    if (waterMarkBean == null) continue block8;
                    opStep.setOperate(OperateEnum.ADD_WATER_MASK.getOperate());
                    Watermark watermark = new Watermark();
                    watermark.setWatermarkType(waterMarkBean.getWartermarkType());
                    watermark.setWatermark(waterMarkBean.getWatermark());
                    if (waterMarkBean.getImageBytes() != null || StringUtils.isNotBlank((CharSequence)waterMarkBean.getImageUrl())) {
                        ImageWater imageWater = new ImageWater();
                        imageWater.setGrayScale(false);
                        if (StringUtils.isNotBlank((CharSequence)waterMarkBean.getImageUrl())) {
                            imageWater.setImageUrl(waterMarkBean.getImageUrl());
                            imageWater.setSourceType(2);
                        } else {
                            imageWater.setImageUrl(waterMarkBean.getImageFileId());
                            imageWater.setSourceType(3);
                        }
                        watermark.setImageWater(imageWater);
                    }
                    if (waterMarkBean.getWatermarkSeting() != null) {
                        watermark.setWatermarkSeting(waterMarkBean.getWatermarkSeting());
                    }
                    opStep.setArgs(watermark);
                    opSteps.add(opStep);
                }
            }
        }
        multiOperateBean.setOpSteps(opSteps);
        return multiOperateBean;
    }

    private List<FileResult> convertByRemoteFile(OperateBean operateBean, String address, String appId, String appSecret) {
        String signature = "";
        if (StringUtils.isNotBlank((CharSequence)appId) && StringUtils.isNotBlank((CharSequence)appSecret)) {
            signature = SignatureUtil.getSignature(null, appId, appSecret);
        }
        String url = this.assembleUrl(operateBean, appId, signature, address);
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u8fdc\u7a0b\u6587\u4ef6\u65b9\u5f0f\u8f6c\u6362\u6587\u4ef6\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)url, (Object)JSON.toJSONString((Object)operateBean));
        }
        long startTime = System.currentTimeMillis();
        String queryUrl = this.convertFileByRemoteFile(operateBean, url);
        return this.pollingQueryConvertResult(queryUrl, appId, signature, startTime);
    }

    private String assembleUrl(OperateBean operateBean, String appId, String signature, String address) {
        String uri = operateBean instanceof SingleOperateBean ? "/api/v2/cps/convert" : "/api/v2/cps/multiOperate";
        if (StringUtils.isBlank((CharSequence)appId)) {
            appId = DEFAULT_APPID;
        }
        String url = address + uri + "?appid=" + appId;
        if (StringUtils.isNotBlank((CharSequence)signature)) {
            url = url + "&signature=" + signature;
        }
        return url;
    }

    private String convertFileByRemoteFile(OperateBean operateBean, String url) {
        ConvertResult convertResult;
        ResponseWrap execute = HttpUtils.post((String)url).addJson((Object)operateBean).execute();
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u8fdc\u7a0b\u6587\u4ef6\u65b9\u5f0f\u8f6c\u6362\u6587\u4ef6\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)execute.getString());
        }
        if (200 != (convertResult = (ConvertResult)JSON.parseObject((String)execute.getString(), ConvertResult.class)).getCode()) {
            throw new FileTransferException("\u8fdc\u7a0b\u6587\u4ef6\u65b9\u5f0f\u8f6c\u6362\u8f6c\u6362\u5931\u8d25\uff1a\u8fd4\u56de\u72b6\u6001\u5f02\u5e38\uff1a" + convertResult.getCode() + "\uff0cmessage\uff1a" + convertResult.getMessage());
        }
        return convertResult.getData();
    }

    private String getDownloadUrl(FileResult fileResult) {
        if (OperateStatusEnum.COMPLETED.getStatus().equals(fileResult.getStatus())) {
            return fileResult.getDownloadUrl();
        }
        throw new FileTransferException("\u6587\u4ef6\u8f6c\u6362\u5931\u8d25\uff0cfileID\uff1a" + fileResult.getFileID() + "\u9519\u8bef\u7801\uff1a" + fileResult.getErrorCode() + "\u9519\u8bef\u63cf\u8ff0\uff1a" + fileResult.getDesc());
    }

    private List<FileResult> convertByLocalFile(OperateBean operateBean, String address, String appId, String appSecret, Map<String, byte[]> bytes) {
        String signature = "";
        if (StringUtils.isNotBlank((CharSequence)appId) && StringUtils.isNotBlank((CharSequence)appSecret)) {
            signature = SignatureUtil.getSignature(null, appId, appSecret);
        }
        String url = this.assembleUrl(operateBean, appId, signature, address);
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u672c\u5730\u6587\u4ef6\u65b9\u5f0f\u8f6c\u6362\u6587\u4ef6\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)url, (Object)JSON.toJSONString((Object)operateBean));
        }
        long startTime = System.currentTimeMillis();
        String queryUrl = this.convertFileByLocalFile(operateBean, url, bytes);
        return this.pollingQueryConvertResult(queryUrl, appId, signature, startTime);
    }

    private String convertFileByLocalFile(OperateBean operateBean, String url, Map<String, byte[]> bytes) {
        ConvertResult convertResult;
        HttpUtils.FormEntity formEntity = HttpUtils.post((String)url).newForm();
        formEntity.addParamter("params", JSON.toJSONString((Object)operateBean));
        for (String key : bytes.keySet()) {
            formEntity.addParamter(key, bytes.get(key), ContentType.MULTIPART_FORM_DATA, key);
        }
        ResponseWrap execute = formEntity.execute();
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u672c\u5730\u6587\u4ef6\u65b9\u5f0f\u8f6c\u6362\u6587\u4ef6\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)execute.getString());
        }
        if (200 != (convertResult = (ConvertResult)JSON.parseObject((String)execute.getString(), ConvertResult.class)).getCode()) {
            throw new FileTransferException("\u672c\u5730\u6587\u4ef6\u65b9\u5f0f\u8f6c\u6362\u6587\u4ef6\u5931\u8d25\uff1a\u8fd4\u56de\u72b6\u6001\u5f02\u5e38\uff1a" + convertResult.getCode() + "\uff0cmessage\uff1a" + convertResult.getMessage());
        }
        return convertResult.getData();
    }

    private List<FileResult> queryConvertResult(String queryUrl) {
        QueryResult queryResult;
        ResponseWrap execute = HttpUtils.get((String)queryUrl).execute();
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u67e5\u8be2\u8f6c\u6362\u7ed3\u679c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)execute.getString());
        }
        if (0 == (queryResult = (QueryResult)JSON.parseObject((String)execute.getString(), QueryResult.class)).getCode()) {
            return queryResult.getData();
        }
        return null;
    }

    private List<FileResult> pollingQueryConvertResult(String queryUrl, String appId, String signature, long startTime) {
        if (StringUtils.isNotBlank((CharSequence)appId) && StringUtils.isNotBlank((CharSequence)signature)) {
            queryUrl = queryUrl + "&appid=" + appId + "&signature=" + signature;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u67e5\u8be2\u8f6c\u6362\u7ed3\u679c\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)queryUrl);
        }
        int errorTimes = 1;
        int queryTimes = 1;
        while (true) {
            try {
                while (true) {
                    long sleepTime;
                    List<FileResult> fileResults;
                    if ((fileResults = this.queryConvertResult(queryUrl)) != null) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("\u672c\u6b21\u8f6c\u6362\u8017\u65f6\uff1a{}ms\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)(System.currentTimeMillis() - startTime), (Object)queryUrl);
                        }
                        return fileResults;
                    }
                    long l = sleepTime = 100 / queryTimes <= 1 ? 1L : (long)(100 / queryTimes);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("pollingQueryConvertResult \u7ebf\u7a0b\u4f11\u7720:{} ms", (Object)sleepTime);
                    }
                    TimeUnit.MILLISECONDS.sleep(sleepTime);
                    ++queryTimes;
                }
            }
            catch (Exception e) {
                if (errorTimes <= 3) {
                    this.log.error("\u7b2c{}\u6b21\u67e5\u8be2\u8f6c\u6362\u72b6\u6001\u5f02\u5e38:{},\u7ee7\u7eed\u91cd\u8bd5", (Object)(++errorTimes), (Object)e.getMessage());
                    continue;
                }
                this.log.error("\u67e5\u8be2\u8f6c\u6362\u72b6\u6001\u5f02\u5e38\u6b21\u6570\u4e3a:3\uff0c\u67e5\u8be2\u5931\u8d25", (Throwable)e);
                throw new FileTransferException("\u67e5\u8be2\u8f6c\u6362\u72b6\u6001\u5f02\u5e38:" + e.getMessage(), e);
            }
            break;
        }
    }

    private byte[] getContent(String downloadUrl) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u5f00\u59cb\u83b7\u53d6\u8f6c\u6362\u540e\u7684\u5185\u5bb9-url:{}", (Object)downloadUrl);
        }
        ResponseWrap responseWrap = HttpUtils.get((String)downloadUrl).execute();
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u8f6c\u6362\u540e\u7684\u5b57\u8282\u6570\u7ec4\u957f\u5ea6:{} byte", (Object)responseWrap.getBytes().length);
        }
        return responseWrap.getBytes();
    }

    private List<OperateResult> getMultiContent(List<FileResult> fileResults) {
        ArrayList<OperateResult> result = new ArrayList<OperateResult>();
        for (FileResult fileResult : fileResults) {
            OperateResult operateResult = new OperateResult();
            operateResult.setDesc(fileResult.getDesc());
            operateResult.setDownloadUrl(fileResult.getDownloadUrl());
            operateResult.setErrorCode(fileResult.getErrorCode());
            operateResult.setFileID(fileResult.getFileID());
            operateResult.setStatus(fileResult.getStatus());
            if (OperateStatusEnum.COMPLETED.getStatus().equals(fileResult.getStatus())) {
                byte[] bytes = this.getContent(fileResult.getDownloadUrl());
                operateResult.setBytes(bytes);
            }
            result.add(operateResult);
        }
        return result;
    }

    private static class Instance {
        private static final WpsFileTransferV2 instance = new WpsFileTransferV2();

        private Instance() {
        }
    }
}

