/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.filetransfer.core.task;

import com.xdja.filetransfer.core.FileTransferFactory;
import com.xdja.filetransfer.core.TransferInterface;
import com.xdja.filetransfer.enums.FileExtensionEnum;
import com.xdja.filetransfer.enums.OperateEnum;
import com.xdja.filetransfer.enums.TypeEnum;
import com.xdja.filetransfer.exception.FileTransferException;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;

public class TransferFileByBytesTask
implements Callable<byte[]> {
    private FileExtensionEnum fileExtensionEnum;
    private byte[] fileBytes;
    private String address;
    private TypeEnum typeEnum;
    private OperateEnum[] operateEnums;
    private String appId;
    private String fileId;
    private String appSecret;

    public TransferFileByBytesTask(String fileId, FileExtensionEnum fileExtensionEnum, byte[] fileBytes, String address, TypeEnum typeEnum, String appId, String appSecret, OperateEnum ... operateEnums) {
        this.fileId = fileId;
        this.fileExtensionEnum = fileExtensionEnum;
        this.fileBytes = fileBytes;
        this.address = address;
        this.typeEnum = typeEnum;
        this.operateEnums = operateEnums;
        this.appId = appId;
        this.appSecret = appSecret;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public TypeEnum getTypeEnum() {
        return this.typeEnum;
    }

    public void setTypeEnum(TypeEnum typeEnum) {
        this.typeEnum = typeEnum;
    }

    public FileExtensionEnum getFileExtensionEnum() {
        return this.fileExtensionEnum;
    }

    public void setFileExtensionEnum(FileExtensionEnum fileExtensionEnum) {
        this.fileExtensionEnum = fileExtensionEnum;
    }

    public byte[] getFileBytes() {
        return this.fileBytes;
    }

    public void setFileBytes(byte[] fileBytes) {
        this.fileBytes = fileBytes;
    }

    public OperateEnum[] getOperateEnums() {
        return this.operateEnums;
    }

    public void setOperateEnums(OperateEnum[] operateEnums) {
        this.operateEnums = operateEnums;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    @Override
    public byte[] call() {
        if (StringUtils.isBlank((CharSequence)this.address)) {
            throw new FileTransferException("\u6587\u4ef6\u8f6c\u6362\u670d\u52a1\u5730\u5740\u4e3a\u7a7a");
        }
        if (this.typeEnum == null) {
            throw new FileTransferException("Type\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (this.fileBytes == null || this.fileBytes.length <= 0) {
            throw new FileTransferException("\u5b57\u8282\u6570\u7ec4\u4e3a\u7a7a");
        }
        TransferInterface transferEngine = FileTransferFactory.getTransferEngine(this.typeEnum);
        return transferEngine.fileTransfer(this.fileId, this.address, this.fileExtensionEnum, this.fileBytes, this.appId, this.appSecret, this.operateEnums);
    }
}

