/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.filetransfer.util;

import java.io.IOException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

public class HttpUtil {
    private HttpResponse response = null;
    private HttpRequestBase method;

    public HttpUtil(HttpRequestBase method) {
        this.method = method;
    }

    public HttpUtil header(Header h2) {
        this.method.setHeader(h2);
        return this;
    }

    public HttpUtil bodyString(String body) {
        if (this.method instanceof HttpPost || this.method instanceof HttpPut || this.method instanceof HttpPatch) {
            ((HttpEntityEnclosingRequestBase)this.method).setEntity((HttpEntity)new StringEntity(body, ContentType.APPLICATION_JSON));
        }
        return this;
    }

    public static HttpUtil post(String url) {
        return new HttpUtil((HttpRequestBase)new HttpPost(url));
    }

    public String respBodyString() {
        String bodyString = "";
        if (null == this.response) {
            return bodyString;
        }
        HttpEntity entity = this.response.getEntity();
        ContentType contentType = ContentType.getOrDefault((HttpEntity)entity);
        Charset charset = contentType.getCharset();
        try {
            bodyString = EntityUtils.toString((HttpEntity)entity, (Charset)charset);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return bodyString;
    }

    private SSLContext createIgnoreVerifySSL() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sc = SSLContext.getInstance("SSLv3");
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        sc.init(null, new TrustManager[]{trustManager}, null);
        return sc;
    }

    public HttpUtil execute() {
        try {
            SSLContext sslcontext = this.createIgnoreVerifySSL();
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslcontext)).build();
            PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager);
            CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
            this.response = httpClient.execute((HttpUriRequest)this.method);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return this;
    }
}

