/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.filetransfer.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.HmacUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureUtil {
    private static final Logger log = LoggerFactory.getLogger(SignatureUtil.class);

    public static String getSignature(Map<String, String> params, String appId, String appSecret) {
        StringBuilder contents = new StringBuilder(appId);
        if (params != null) {
            ArrayList<String> keys = new ArrayList<String>();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                keys.add(entry.getKey());
            }
            Collections.sort(keys, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareTo(o2);
                }
            });
            for (String key : keys) {
                if ("appId".equals(key) || "appSecret".equals(key)) continue;
                contents.append(key).append(params.get(key));
            }
        }
        contents.append(appSecret);
        byte[] bytes = HmacUtils.hmacSha1((byte[])appSecret.getBytes(), (byte[])contents.toString().getBytes());
        String sign = Base64.encodeBase64String((byte[])bytes);
        if (log.isDebugEnabled()) {
            log.debug("\u7b7e\u540d\u4fe1\u606f\uff1a{}", (Object)sign);
        }
        return sign;
    }
}

