/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.base.generators;

import com.xdja.jce.base.ec.ECConstants;
import com.xdja.jce.base.ec.ECMultiplier;
import com.xdja.jce.base.ec.ECPoint;
import com.xdja.jce.base.ec.FixedPointCombMultiplier;
import com.xdja.jce.base.ec.WNafUtil;
import com.xdja.jce.base.generators.AsymmetricCipherKeyPairGenerator;
import com.xdja.jce.base.key.AsymmetricCipherKeyPair;
import com.xdja.jce.base.params.ECDomainParameters;
import com.xdja.jce.base.params.ECKeyGenerationParameters;
import com.xdja.jce.base.params.ECPrivateKeyParameters;
import com.xdja.jce.base.params.ECPublicKeyParameters;
import com.xdja.jce.base.params.KeyGenerationParameters;
import com.xdja.jce.core.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    ECDomainParameters params;
    SecureRandom random;

    @Override
    public void init(KeyGenerationParameters param) {
        ECKeyGenerationParameters ecP = (ECKeyGenerationParameters)param;
        this.random = ecP.getRandom();
        this.params = ecP.getDomainParameters();
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger d;
        BigInteger n = this.params.getN();
        int nBitLength = n.bitLength();
        int minWeight = nBitLength >>> 2;
        while ((d = BigIntegers.createRandomBigInteger((int)nBitLength, (SecureRandom)this.random)).compareTo(ONE) < 0 || d.compareTo(n) >= 0 || WNafUtil.getNafWeight(d) < minWeight) {
        }
        ECPoint Q = this.createBasePointMultiplier().multiply(this.params.getG(), d);
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(Q, this.params), new ECPrivateKeyParameters(d, this.params));
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

