/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.base.provider.config;

import com.xdja.jce.base.cipher.BlockCipher;
import com.xdja.jce.base.cipher.DecoratorBlockCipher;
import com.xdja.jce.base.cipher.GMAsymmetricCipher;
import com.xdja.jce.base.cipher.asymmetric.DecoratorGMAsymmetricCipher;
import com.xdja.jce.base.cipher.asymmetric.DecoratorKeyFactory;
import com.xdja.jce.base.cipher.asymmetric.DecoratorKeyPairGenerator;
import com.xdja.jce.base.cipher.asymmetric.KeyFactorySpi;
import com.xdja.jce.base.keystore.XdjaKeyStoreSpi;
import com.xdja.jce.base.provider.XdjaProvider;
import com.xdja.jce.base.provider.config.Config;
import com.xdja.jce.base.provider.config.DeviceProviderList;
import com.xdja.jce.base.provider.config.DeviceProviders;
import com.xdja.jce.base.random.XdjaSecureRandomSpi;
import com.xdja.jce.base.signers.DecoratorSigner;
import com.xdja.jce.base.signers.Signer;
import com.xdja.jce.base.x509.CertificateFactoryAgent;
import com.xdja.jce.base.x509.DecoratorCertificateFactory;
import com.xdja.jce.core.provider.Service;
import com.xdja.jce.hash.digest.DecoratorDigest;
import com.xdja.jce.hash.digest.Digest;
import java.security.KeyPairGenerator;
import java.util.List;

public class GetInstance {
    public static Digest getDigestEngineInstance(String alg) {
        DeviceProviderList providerList = DeviceProviders.getProviderList();
        List<Service> services = providerList.getServices("digest", alg);
        Service service = GetInstance.getService(alg, services);
        Object object = service.newInstance(XdjaProvider.classLoader);
        DecoratorDigest digest = null;
        if (object instanceof Digest) {
            digest = new DecoratorDigest((Digest)object);
            digest.setDeviceProvider(service.getProvider());
        }
        return digest;
    }

    public static BlockCipher getSymmetricCipherEngineInstance(String alg) {
        DeviceProviderList providerList = DeviceProviders.getProviderList();
        List<Service> services = providerList.getServices("cipher", alg);
        Service service = GetInstance.getService(alg, services);
        Object object = service.newInstance(XdjaProvider.classLoader);
        if (object instanceof BlockCipher) {
            BlockCipher blockCipher = (BlockCipher)object;
            if (Config.cipher_device_provider_view) {
                DecoratorBlockCipher decoratorBlockCipher = new DecoratorBlockCipher(blockCipher);
                decoratorBlockCipher.setDeviceProvider(service.getProvider());
                return decoratorBlockCipher;
            }
            return blockCipher;
        }
        return null;
    }

    public static GMAsymmetricCipher getGmCipherEngineInstance(String alg) {
        DeviceProviderList providerList = DeviceProviders.getProviderList();
        List<Service> services = providerList.getServices("asymmetric", alg);
        Service service = GetInstance.getService(alg, services);
        Object object = service.newInstance(XdjaProvider.classLoader);
        if (object instanceof GMAsymmetricCipher) {
            DecoratorGMAsymmetricCipher gmAsymmetricCipher = new DecoratorGMAsymmetricCipher((GMAsymmetricCipher)object, service.getProvider());
            return gmAsymmetricCipher;
        }
        return null;
    }

    public static Signer getGmSignerEngineInstance(String alg) {
        DeviceProviderList providerList = DeviceProviders.getProviderList();
        List<Service> services = providerList.getServices("signer", alg);
        Service service = GetInstance.getService(alg, services);
        Object object = service.newInstance(XdjaProvider.classLoader);
        if (object instanceof Signer) {
            DecoratorSigner decoratorSigner = new DecoratorSigner((Signer)object, service.getProvider());
            return decoratorSigner;
        }
        return null;
    }

    public static KeyPairGenerator getKeyPairGeneratorEngineInstance(String alg) {
        DeviceProviderList providerList = DeviceProviders.getProviderList();
        List<Service> services = providerList.getServices("asymmetric", alg);
        Service service = GetInstance.getService(alg, services);
        Object object = service.newInstance(XdjaProvider.classLoader);
        if (object instanceof KeyPairGenerator) {
            DecoratorKeyPairGenerator decorator = new DecoratorKeyPairGenerator((KeyPairGenerator)object);
            decorator.setDeviceProvider(service.getProvider());
            return decorator;
        }
        return null;
    }

    public static KeyFactorySpi getKeyFactoryEngineInstance(String alg) {
        DeviceProviderList providerList = DeviceProviders.getProviderList();
        List<Service> services = providerList.getServices("key", alg);
        Service service = GetInstance.getService(alg, services);
        Object object = service.newInstance(XdjaProvider.classLoader);
        if (object instanceof KeyFactorySpi) {
            DecoratorKeyFactory decorator = new DecoratorKeyFactory((KeyFactorySpi)object);
            decorator.setDeviceProvider(service.getProvider());
            return decorator;
        }
        return null;
    }

    public static CertificateFactoryAgent getCertificateFactoryEngineInstance(String alg) {
        DeviceProviderList providerList = DeviceProviders.getProviderList();
        List<Service> services = providerList.getServices("cert", alg);
        Service service = GetInstance.getService(alg, services);
        Object object = service.newInstance(XdjaProvider.classLoader);
        if (object instanceof CertificateFactoryAgent) {
            DecoratorCertificateFactory decorator = new DecoratorCertificateFactory((CertificateFactoryAgent)object);
            decorator.setDeviceProvider(service.getProvider());
            return decorator;
        }
        return null;
    }

    public static XdjaKeyStoreSpi getKeyStoreEngineInstance(String alg) {
        DeviceProviderList providerList = DeviceProviders.getProviderList();
        List<Service> services = providerList.getServices("keystore", alg);
        Service service = GetInstance.getService(alg, services);
        Object object = service.newInstance(XdjaProvider.classLoader);
        if (object instanceof XdjaKeyStoreSpi) {
            return (XdjaKeyStoreSpi)object;
        }
        return null;
    }

    public static XdjaSecureRandomSpi getRandomEngineInstance(String alg) {
        DeviceProviderList providerList = DeviceProviders.getProviderList();
        List<Service> services = providerList.getServices("random", alg);
        Service service = GetInstance.getService(alg, services);
        Object object = service.newInstance(XdjaProvider.classLoader);
        if (object instanceof XdjaSecureRandomSpi) {
            return (XdjaSecureRandomSpi)object;
        }
        return null;
    }

    private static Service getService(String alg, List<Service> services) {
        Service target = services.get(0);
        String providerName = Config.getAlgorithmProvider(alg);
        if (null == providerName) {
            return target;
        }
        for (Service service : services) {
            if (!service.getProvider().getName().equals(providerName)) continue;
            target = service;
            break;
        }
        return target;
    }
}

