/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.base.random;

import com.xdja.jce.base.mac.HMac;
import com.xdja.jce.base.prng.EntropySource;
import com.xdja.jce.base.prng.EntropySourceProvider;
import com.xdja.jce.base.prng.SP800SecureRandom;
import com.xdja.jce.base.prng.SP800SecureRandomBuilder;
import com.xdja.jce.base.random.XdjaSecureRandomSpi;
import com.xdja.jce.core.util.Arrays;
import com.xdja.jce.core.util.ClassUtil;
import com.xdja.jce.core.util.Pack;
import com.xdja.jce.core.util.Properties;
import com.xdja.jce.core.util.Strings;
import com.xdja.jce.hash.digest.Digest;
import com.xdja.jce.hash.engine.SHA512Digest;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import java.security.Security;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class DRBG {
    private static final String PREFIX = DRBG.class.getName();
    private static final String[][] initialEntropySourceNames = new String[][]{{"sun.security.provider.Sun", "sun.security.provider.SecureRandom"}, {"org.apache.harmony.security.provider.crypto.CryptoProvider", "org.apache.harmony.security.provider.crypto.SHA1PRNG_SecureRandomImpl"}, {"com.android.org.conscrypt.OpenSSLProvider", "com.android.org.conscrypt.OpenSSLRandom"}, {"org.conscrypt.OpenSSLProvider", "org.conscrypt.OpenSSLRandom"}};

    private static final Object[] findSource() {
        for (int t = 0; t < initialEntropySourceNames.length; ++t) {
            String[] pair = initialEntropySourceNames[t];
            try {
                Object[] r = new Object[]{Class.forName(pair[0]).newInstance(), Class.forName(pair[1]).newInstance()};
                return r;
            }
            catch (Throwable ex) {
                continue;
            }
        }
        return null;
    }

    private static SecureRandom createInitialEntropySource() {
        boolean hasGetInstanceStrong = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    Class<SecureRandom> def = SecureRandom.class;
                    return def.getMethod("getInstanceStrong", new Class[0]) != null;
                }
                catch (Exception e) {
                    return false;
                }
            }
        });
        if (hasGetInstanceStrong) {
            return AccessController.doPrivileged(new PrivilegedAction<SecureRandom>(){

                @Override
                public SecureRandom run() {
                    try {
                        return (SecureRandom)SecureRandom.class.getMethod("getInstanceStrong", new Class[0]).invoke(null, new Object[0]);
                    }
                    catch (Exception e) {
                        return DRBG.createCoreSecureRandom();
                    }
                }
            });
        }
        return DRBG.createCoreSecureRandom();
    }

    private static SecureRandom createCoreSecureRandom() {
        if (Security.getProperty("securerandom.source") == null) {
            return new CoreSecureRandom(DRBG.findSource());
        }
        try {
            String source = Security.getProperty("securerandom.source");
            return new URLSeededSecureRandom(new URL(source));
        }
        catch (Exception e) {
            return new CoreSecureRandom(DRBG.findSource());
        }
    }

    private static EntropySourceProvider createEntropySource() {
        final String sourceClass = Properties.getPropertyValue((String)"org.bouncycastle.drbg.entropysource");
        return AccessController.doPrivileged(new PrivilegedAction<EntropySourceProvider>(){

            @Override
            public EntropySourceProvider run() {
                try {
                    Class clazz = ClassUtil.loadClass(DRBG.class, (String)sourceClass);
                    return (EntropySourceProvider)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new IllegalStateException("entropy source " + sourceClass + " not created: " + e.getMessage(), e);
                }
            }
        });
    }

    private static SecureRandom createBaseRandom(boolean isPredictionResistant) {
        if (Properties.getPropertyValue((String)"org.bouncycastle.drbg.entropysource") != null) {
            EntropySourceProvider entropyProvider = DRBG.createEntropySource();
            EntropySource initSource = entropyProvider.get(128);
            byte[] personalisationString = isPredictionResistant ? DRBG.generateDefaultPersonalizationString(initSource.getEntropy()) : DRBG.generateNonceIVPersonalizationString(initSource.getEntropy());
            return new SP800SecureRandomBuilder(entropyProvider).setPersonalizationString(personalisationString).buildHash((Digest)new SHA512Digest(), Arrays.concatenate((byte[])initSource.getEntropy(), (byte[])initSource.getEntropy()), isPredictionResistant);
        }
        HybridSecureRandom randomSource = new HybridSecureRandom();
        byte[] personalisationString = isPredictionResistant ? DRBG.generateDefaultPersonalizationString(((SecureRandom)randomSource).generateSeed(16)) : DRBG.generateNonceIVPersonalizationString(((SecureRandom)randomSource).generateSeed(16));
        return new SP800SecureRandomBuilder(randomSource, true).setPersonalizationString(personalisationString).buildHash((Digest)new SHA512Digest(), ((SecureRandom)randomSource).generateSeed(32), isPredictionResistant);
    }

    private static byte[] generateDefaultPersonalizationString(byte[] seed) {
        return Arrays.concatenate((byte[])Strings.toByteArray((String)"Default"), (byte[])seed, (byte[])Pack.longToBigEndian((long)Thread.currentThread().getId()), (byte[])Pack.longToBigEndian((long)System.currentTimeMillis()));
    }

    private static byte[] generateNonceIVPersonalizationString(byte[] seed) {
        return Arrays.concatenate((byte[])Strings.toByteArray((String)"Nonce"), (byte[])seed, (byte[])Pack.longToLittleEndian((long)Thread.currentThread().getId()), (byte[])Pack.longToLittleEndian((long)System.currentTimeMillis()));
    }

    static /* synthetic */ SecureRandom access$100(boolean x0) {
        return DRBG.createBaseRandom(x0);
    }

    static /* synthetic */ SecureRandom access$300() {
        return DRBG.createInitialEntropySource();
    }

    private static class HybridSecureRandom
    extends SecureRandom {
        private final AtomicBoolean seedAvailable = new AtomicBoolean(false);
        private final AtomicInteger samples = new AtomicInteger(0);
        private final SecureRandom baseRandom = DRBG.access$300();
        private final SP800SecureRandom drbg = new SP800SecureRandomBuilder(new EntropySourceProvider(){

            @Override
            public EntropySource get(int bitsRequired) {
                return new SignallingEntropySource(bitsRequired);
            }
        }).setPersonalizationString(Strings.toByteArray((String)"Bouncy Castle Hybrid Entropy Source")).buildHMAC(new HMac((Digest)new SHA512Digest()), this.baseRandom.generateSeed(32), false);

        HybridSecureRandom() {
            super(null, new HybridRandomProvider());
        }

        @Override
        public void setSeed(byte[] seed) {
            if (this.drbg != null) {
                this.drbg.setSeed(seed);
            }
        }

        @Override
        public void setSeed(long seed) {
            if (this.drbg != null) {
                this.drbg.setSeed(seed);
            }
        }

        @Override
        public byte[] generateSeed(int numBytes) {
            byte[] data = new byte[numBytes];
            if (this.samples.getAndIncrement() > 20 && this.seedAvailable.getAndSet(false)) {
                this.samples.set(0);
                this.drbg.reseed((byte[])null);
            }
            this.drbg.nextBytes(data);
            return data;
        }

        private class SignallingEntropySource
        implements EntropySource {
            private final int byteLength;
            private final AtomicReference entropy = new AtomicReference();
            private final AtomicBoolean scheduled = new AtomicBoolean(false);

            SignallingEntropySource(int bitsRequired) {
                this.byteLength = (bitsRequired + 7) / 8;
            }

            @Override
            public boolean isPredictionResistant() {
                return true;
            }

            @Override
            public byte[] getEntropy() {
                byte[] seed = this.entropy.getAndSet(null);
                if (seed == null || seed.length != this.byteLength) {
                    seed = HybridSecureRandom.this.baseRandom.generateSeed(this.byteLength);
                } else {
                    this.scheduled.set(false);
                }
                if (!this.scheduled.getAndSet(true)) {
                    Thread gatherer = new Thread(new EntropyGatherer(this.byteLength));
                    gatherer.setDaemon(true);
                    gatherer.start();
                }
                return seed;
            }

            @Override
            public int entropySize() {
                return this.byteLength * 8;
            }

            private class EntropyGatherer
            implements Runnable {
                private final int numBytes;

                EntropyGatherer(int numBytes) {
                    this.numBytes = numBytes;
                }

                private void sleep(long ms) {
                    try {
                        Thread.sleep(ms);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }

                @Override
                public void run() {
                    byte[] rn;
                    long ms;
                    String pause = Properties.getPropertyValue((String)"org.bouncycastle.drbg.gather_pause_secs");
                    if (pause != null) {
                        try {
                            ms = Long.parseLong(pause) * 1000L;
                        }
                        catch (Exception e) {
                            ms = 5000L;
                        }
                    } else {
                        ms = 5000L;
                    }
                    byte[] seed = new byte[this.numBytes];
                    for (int i = 0; i < SignallingEntropySource.this.byteLength / 8; ++i) {
                        this.sleep(ms);
                        rn = HybridSecureRandom.this.baseRandom.generateSeed(8);
                        System.arraycopy(rn, 0, seed, i * 8, rn.length);
                    }
                    int extra = SignallingEntropySource.this.byteLength - SignallingEntropySource.this.byteLength / 8 * 8;
                    if (extra != 0) {
                        this.sleep(ms);
                        rn = HybridSecureRandom.this.baseRandom.generateSeed(extra);
                        System.arraycopy(rn, 0, seed, seed.length - rn.length, rn.length);
                    }
                    SignallingEntropySource.this.entropy.set(seed);
                    HybridSecureRandom.this.seedAvailable.set(true);
                }
            }
        }
    }

    private static class URLSeededSecureRandom
    extends SecureRandom {
        private final InputStream seedStream;

        URLSeededSecureRandom(final URL url) {
            super(null, new HybridRandomProvider());
            this.seedStream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                @Override
                public InputStream run() {
                    try {
                        return url.openStream();
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("unable to open random source");
                    }
                }
            });
        }

        @Override
        public void setSeed(byte[] seed) {
        }

        @Override
        public void setSeed(long seed) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] generateSeed(int numBytes) {
            URLSeededSecureRandom uRLSeededSecureRandom = this;
            synchronized (uRLSeededSecureRandom) {
                int off;
                int len;
                byte[] data = new byte[numBytes];
                for (off = 0; off != data.length && (len = this.privilegedRead(data, off, data.length - off)) > -1; off += len) {
                }
                if (off != data.length) {
                    throw new InternalError("unable to fully read random source");
                }
                return data;
            }
        }

        private int privilegedRead(final byte[] data, final int off, final int len) {
            return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

                @Override
                public Integer run() {
                    try {
                        return seedStream.read(data, off, len);
                    }
                    catch (IOException e) {
                        throw new InternalError("unable to read random source");
                    }
                }
            });
        }
    }

    private static class HybridRandomProvider
    extends Provider {
        protected HybridRandomProvider() {
            super("BCHEP", 1.0, "Bouncy Castle Hybrid Entropy Provider");
        }
    }

    public static class NonceAndIV
    extends SecureRandomSpi
    implements XdjaSecureRandomSpi {
        private static final SecureRandom random = DRBG.access$100(false);

        @Override
        public void engineSetSeed(byte[] bytes) {
            random.setSeed(bytes);
        }

        @Override
        public void engineNextBytes(byte[] bytes) {
            random.nextBytes(bytes);
        }

        @Override
        public byte[] engineGenerateSeed(int numBytes) {
            return random.generateSeed(numBytes);
        }
    }

    public static class Default
    extends SecureRandomSpi
    implements XdjaSecureRandomSpi {
        private static final SecureRandom random = DRBG.access$100(true);

        @Override
        public void engineSetSeed(byte[] bytes) {
            random.setSeed(bytes);
        }

        @Override
        public void engineNextBytes(byte[] bytes) {
            random.nextBytes(bytes);
        }

        @Override
        public byte[] engineGenerateSeed(int numBytes) {
            return random.generateSeed(numBytes);
        }
    }

    private static class CoreSecureRandom
    extends SecureRandom {
        CoreSecureRandom(Object[] initialEntropySourceAndSpi) {
            super((SecureRandomSpi)initialEntropySourceAndSpi[1], (Provider)initialEntropySourceAndSpi[0]);
        }
    }
}

