/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.base.x509;

import com.xdja.jce.base.common.JcaJceHelper;
import com.xdja.jce.base.x509.ExtCRLException;
import com.xdja.jce.base.x509.X509CRLImpl;
import com.xdja.jce.base.x509.X509CRLInternal;
import com.xdja.jce.base.x509.X509SignatureUtil;
import com.xdja.jce.coding.asn1.ASN1Encodable;
import com.xdja.jce.coding.asn1.ASN1Primitive;
import com.xdja.jce.coding.asn1.DERBitString;
import com.xdja.jce.coding.asn1.x509.CertificateList;
import com.xdja.jce.coding.asn1.x509.Extension;
import com.xdja.jce.coding.asn1.x509.IssuingDistributionPoint;
import java.security.cert.CRLException;

public class X509CRLObject
extends X509CRLImpl {
    private final Object cacheLock = new Object();
    private X509CRLInternal internalCRLValue;
    private volatile boolean hashValueSet;
    private volatile int hashValue;

    public X509CRLObject(JcaJceHelper bcHelper, CertificateList c) throws CRLException {
        super(bcHelper, c, X509CRLObject.createSigAlgName(c), X509CRLObject.createSigAlgParams(c), X509CRLObject.isIndirectCRL(c));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof X509CRLObject) {
            DERBitString signature;
            X509CRLObject otherBC = (X509CRLObject)other;
            if (this.hashValueSet && otherBC.hashValueSet ? this.hashValue != otherBC.hashValue : (null == this.internalCRLValue || null == otherBC.internalCRLValue) && null != (signature = this.c.getSignature()) && !signature.equals((ASN1Primitive)otherBC.c.getSignature())) {
                return false;
            }
        }
        return this.getInternalCRL().equals(other);
    }

    @Override
    public int hashCode() {
        if (!this.hashValueSet) {
            this.hashValue = this.getInternalCRL().hashCode();
            this.hashValueSet = true;
        }
        return this.hashValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509CRLInternal getInternalCRL() {
        byte[] encoding;
        Object object = this.cacheLock;
        synchronized (object) {
            if (null != this.internalCRLValue) {
                return this.internalCRLValue;
            }
        }
        try {
            encoding = this.getEncoded();
        }
        catch (CRLException e) {
            encoding = null;
        }
        X509CRLInternal temp = new X509CRLInternal(this.bcHelper, this.c, this.sigAlgName, this.sigAlgParams, this.isIndirect, encoding);
        Object object2 = this.cacheLock;
        synchronized (object2) {
            if (null == this.internalCRLValue) {
                this.internalCRLValue = temp;
            }
            return this.internalCRLValue;
        }
    }

    private static String createSigAlgName(CertificateList c) throws CRLException {
        try {
            return X509SignatureUtil.getSignatureName(c.getSignatureAlgorithm());
        }
        catch (Exception e) {
            throw new CRLException("CRL contents invalid: " + e);
        }
    }

    private static byte[] createSigAlgParams(CertificateList c) throws CRLException {
        try {
            ASN1Encodable parameters = c.getSignatureAlgorithm().getParameters();
            if (null == parameters) {
                return null;
            }
            return parameters.toASN1Primitive().getEncoded("DER");
        }
        catch (Exception e) {
            throw new CRLException("CRL contents invalid: " + e);
        }
    }

    private static boolean isIndirectCRL(CertificateList c) throws CRLException {
        try {
            byte[] extOctets = X509CRLObject.getExtensionOctets(c, Extension.issuingDistributionPoint.getId());
            if (null == extOctets) {
                return false;
            }
            return IssuingDistributionPoint.getInstance((Object)extOctets).isIndirectCRL();
        }
        catch (Exception e) {
            throw new ExtCRLException("Exception reading IssuingDistributionPoint", e);
        }
    }
}

