/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.base.x509;

import com.xdja.jce.base.util.MessageDigestUtils;
import com.xdja.jce.base.x9.X9ObjectIdentifiers;
import com.xdja.jce.coding.asn1.ASN1Encodable;
import com.xdja.jce.coding.asn1.ASN1Null;
import com.xdja.jce.coding.asn1.ASN1ObjectIdentifier;
import com.xdja.jce.coding.asn1.ASN1Primitive;
import com.xdja.jce.coding.asn1.ASN1Sequence;
import com.xdja.jce.coding.asn1.DERNull;
import com.xdja.jce.coding.asn1.edec.EdECObjectIdentifiers;
import com.xdja.jce.coding.asn1.oiw.OIWObjectIdentifiers;
import com.xdja.jce.coding.asn1.pkcs.PKCSObjectIdentifiers;
import com.xdja.jce.coding.asn1.pkcs.RSASSAPSSparams;
import com.xdja.jce.coding.asn1.x509.AlgorithmIdentifier;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.PSSParameterSpec;
import java.util.HashMap;
import java.util.Map;

class X509SignatureUtil {
    private static final Map<ASN1ObjectIdentifier, String> algNames = new HashMap<ASN1ObjectIdentifier, String>();
    private static final ASN1Null derNull;

    X509SignatureUtil() {
    }

    static void setSignatureParameters(Signature signature, ASN1Encodable params) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        if (params != null && !derNull.equals(params)) {
            AlgorithmParameters sigParams = AlgorithmParameters.getInstance(signature.getAlgorithm(), signature.getProvider());
            try {
                sigParams.init(params.toASN1Primitive().getEncoded());
            }
            catch (IOException e) {
                throw new SignatureException("IOException decoding parameters: " + e.getMessage());
            }
            if (signature.getAlgorithm().endsWith("MGF1")) {
                try {
                    signature.setParameter(sigParams.getParameterSpec(PSSParameterSpec.class));
                }
                catch (GeneralSecurityException e) {
                    throw new SignatureException("Exception extracting parameters: " + e.getMessage());
                }
            }
        }
    }

    static String getSignatureName(AlgorithmIdentifier sigAlgId) {
        String algName;
        ASN1Encodable params = sigAlgId.getParameters();
        if (params != null && !derNull.equals(params)) {
            if (sigAlgId.getAlgorithm().equals((ASN1Primitive)PKCSObjectIdentifiers.id_RSASSA_PSS)) {
                RSASSAPSSparams rsaParams = RSASSAPSSparams.getInstance((Object)params);
                return X509SignatureUtil.getDigestAlgName(rsaParams.getHashAlgorithm().getAlgorithm()) + "withRSAandMGF1";
            }
            if (sigAlgId.getAlgorithm().equals((ASN1Primitive)X9ObjectIdentifiers.ecdsa_with_SHA2)) {
                ASN1Sequence ecDsaParams = ASN1Sequence.getInstance((Object)params);
                return X509SignatureUtil.getDigestAlgName((ASN1ObjectIdentifier)ecDsaParams.getObjectAt(0)) + "withECDSA";
            }
        }
        if ((algName = algNames.get(sigAlgId.getAlgorithm())) != null) {
            return algName;
        }
        return X509SignatureUtil.findAlgName(sigAlgId.getAlgorithm());
    }

    private static String getDigestAlgName(ASN1ObjectIdentifier digestAlgOID) {
        String name = MessageDigestUtils.getDigestName(digestAlgOID);
        int dIndex = name.indexOf(45);
        if (dIndex > 0 && !name.startsWith("SHA3")) {
            return name.substring(0, dIndex) + name.substring(dIndex + 1);
        }
        return MessageDigestUtils.getDigestName(digestAlgOID);
    }

    private static String findAlgName(ASN1ObjectIdentifier algOid) {
        String algName;
        Provider prov = Security.getProvider("XDJA");
        if (prov != null && (algName = X509SignatureUtil.lookupAlg(prov, algOid)) != null) {
            return algName;
        }
        Provider[] provs = Security.getProviders();
        for (int i = 0; i != provs.length; ++i) {
            String algName2;
            if (prov == provs[i] || (algName2 = X509SignatureUtil.lookupAlg(provs[i], algOid)) == null) continue;
            return algName2;
        }
        return algOid.getId();
    }

    private static String lookupAlg(Provider prov, ASN1ObjectIdentifier algOid) {
        String algName = prov.getProperty("Alg.Alias.Signature." + algOid);
        if (algName != null) {
            return algName;
        }
        algName = prov.getProperty("Alg.Alias.Signature.OID." + algOid);
        if (algName != null) {
            return algName;
        }
        return null;
    }

    static {
        algNames.put(EdECObjectIdentifiers.id_Ed25519, "Ed25519");
        algNames.put(EdECObjectIdentifiers.id_Ed448, "Ed448");
        algNames.put(OIWObjectIdentifiers.dsaWithSHA1, "SHA1withDSA");
        algNames.put(X9ObjectIdentifiers.id_dsa_with_sha1, "SHA1withDSA");
        derNull = DERNull.INSTANCE;
    }
}

