/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.base.x9;

import com.xdja.jce.base.ec.CustomNamedCurves;
import com.xdja.jce.base.gm.GMNamedCurves;
import com.xdja.jce.base.nist.NISTNamedCurves;
import com.xdja.jce.base.params.ECDomainParameters;
import com.xdja.jce.base.sec.SECNamedCurves;
import com.xdja.jce.base.x9.X962NamedCurves;
import com.xdja.jce.base.x9.X9ECParameters;
import com.xdja.jce.base.x9.X9ECPoint;
import com.xdja.jce.coding.asn1.ASN1ObjectIdentifier;
import com.xdja.jce.coding.asn1.cryptlib.CryptlibObjectIdentifiers;
import java.util.Enumeration;
import java.util.Vector;

public class ECNamedCurveTable {
    public static X9ECParameters getByName(String name) {
        X9ECParameters ecP = X962NamedCurves.getByName(name);
        if (ecP == null) {
            ecP = SECNamedCurves.getByName(name);
        }
        if (ecP == null) {
            ecP = NISTNamedCurves.getByName(name);
        }
        if (ecP == null) {
            ecP = GMNamedCurves.getByName(name);
        }
        return ecP;
    }

    public static ASN1ObjectIdentifier getOID(String name) {
        ASN1ObjectIdentifier oid = X962NamedCurves.getOID(name);
        if (oid == null) {
            oid = SECNamedCurves.getOID(name);
        }
        if (oid == null) {
            oid = NISTNamedCurves.getOID(name);
        }
        if (oid == null) {
            oid = GMNamedCurves.getOID(name);
        }
        if (oid == null && name.equals("curve25519")) {
            oid = CryptlibObjectIdentifiers.curvey25519;
        }
        return oid;
    }

    public static String getName(ASN1ObjectIdentifier oid) {
        String name = X962NamedCurves.getName(oid);
        if (name == null) {
            name = SECNamedCurves.getName(oid);
        }
        if (name == null) {
            name = NISTNamedCurves.getName(oid);
        }
        if (name == null) {
            name = GMNamedCurves.getName(oid);
        }
        if (name == null) {
            name = CustomNamedCurves.getName(oid);
        }
        return name;
    }

    public static X9ECParameters getByOID(ASN1ObjectIdentifier oid) {
        X9ECParameters ecP = X962NamedCurves.getByOID(oid);
        if (ecP == null) {
            ecP = SECNamedCurves.getByOID(oid);
        }
        if (ecP == null) {
            ecP = GMNamedCurves.getByOID(oid);
        }
        return ecP;
    }

    public static Enumeration getNames() {
        Vector v = new Vector();
        ECNamedCurveTable.addEnumeration(v, X962NamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(v, SECNamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(v, NISTNamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(v, GMNamedCurves.getNames());
        return v.elements();
    }

    private static void addEnumeration(Vector v, Enumeration e) {
        while (e.hasMoreElements()) {
            v.addElement(e.nextElement());
        }
    }

    private static X9ECParameters fromDomainParameters(ECDomainParameters dp) {
        return dp == null ? null : new X9ECParameters(dp.getCurve(), new X9ECPoint(dp.getG(), false), dp.getN(), dp.getH(), dp.getSeed());
    }
}

