/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.base.cipher.asymmetric;

import com.xdja.jce.base.cipher.asymmetric.ECUtils;
import com.xdja.jce.base.cipher.asymmetric.util.ECUtil;
import com.xdja.jce.base.common.JcaJceHelper;
import com.xdja.jce.base.common.XdjaJcaJceHelper;
import com.xdja.jce.base.params.CipherParameters;
import com.xdja.jce.base.params.ParametersWithID;
import com.xdja.jce.base.params.ParametersWithRandom;
import com.xdja.jce.base.signers.Signer;
import com.xdja.jce.base.spec.GMParameterSpec;
import com.xdja.jce.core.exception.CryptoException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public class GMSignatureSpi
extends Signature {
    private final JcaJceHelper helper = new XdjaJcaJceHelper();
    private AlgorithmParameters engineParams;
    private GMParameterSpec paramSpec;
    private final Signer signer;

    public GMSignatureSpi(String algorithms, Signer signer) {
        super(algorithms);
        this.signer = signer;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        CipherParameters param = ECUtils.generatePublicKeyParameter(publicKey);
        if (this.paramSpec != null) {
            param = new ParametersWithID(param, this.paramSpec.getID());
        }
        this.signer.init(false, param);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        CipherParameters param = ECUtil.generatePrivateKeyParameter(privateKey);
        if (this.appRandom != null) {
            param = new ParametersWithRandom(param, this.appRandom);
        }
        if (this.paramSpec != null) {
            this.signer.init(true, new ParametersWithID(param, this.paramSpec.getID()));
        } else {
            this.signer.init(true, param);
        }
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.signer.update(b);
    }

    @Override
    protected void engineUpdate(byte[] bytes, int off, int length) throws SignatureException {
        this.signer.update(bytes, off, length);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        try {
            return this.signer.generateSignature();
        }
        catch (CryptoException e) {
            throw new SignatureException("unable to create signature: " + e.getMessage());
        }
    }

    @Override
    protected boolean engineVerify(byte[] bytes) throws SignatureException {
        return this.signer.verifySignature(bytes);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (!(params instanceof GMParameterSpec)) {
            throw new InvalidAlgorithmParameterException("only SM2ParameterSpec supported");
        }
        this.paramSpec = (GMParameterSpec)params;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null && this.paramSpec != null) {
            try {
                this.engineParams = this.helper.createAlgorithmParameters("PSS");
                this.engineParams.init(this.paramSpec);
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
        }
        return this.engineParams;
    }

    @Override
    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineGetParameter unsupported");
    }

    public Signer getSigner() {
        return this.signer;
    }
}

