/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.base.encodings;

import com.xdja.jce.base.cipher.AsymmetricCipher;
import com.xdja.jce.base.common.CryptoServicesRegistrar;
import com.xdja.jce.base.params.CipherParameters;
import com.xdja.jce.base.params.ParametersWithRandom;
import com.xdja.jce.core.exception.DataLengthException;
import com.xdja.jce.core.exception.InvalidCipherTextException;
import com.xdja.jce.core.util.Arrays;
import com.xdja.jce.hash.digest.Digest;
import com.xdja.jce.hash.digest.DigestFactory;
import java.security.SecureRandom;

public class OAEPEncoding
implements AsymmetricCipher {
    private byte[] defHash;
    private Digest mgf1Hash;
    private AsymmetricCipher engine;
    private SecureRandom random;
    private boolean forEncryption;

    public OAEPEncoding(AsymmetricCipher cipher) {
        this(cipher, DigestFactory.createSHA1(), null);
    }

    public OAEPEncoding(AsymmetricCipher cipher, Digest hash) {
        this(cipher, hash, null);
    }

    public OAEPEncoding(AsymmetricCipher cipher, Digest hash, byte[] encodingParams) {
        this(cipher, hash, hash, encodingParams);
    }

    public OAEPEncoding(AsymmetricCipher cipher, Digest hash, Digest mgf1Hash, byte[] encodingParams) {
        this.engine = cipher;
        this.mgf1Hash = mgf1Hash;
        this.defHash = new byte[hash.getDigestSize()];
        hash.reset();
        if (encodingParams != null) {
            hash.update(encodingParams, 0, encodingParams.length);
        }
        hash.doFinal(this.defHash, 0);
    }

    public AsymmetricCipher getUnderlyingCipher() {
        return this.engine;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters param) {
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.random = rParam.getRandom();
        } else {
            this.random = CryptoServicesRegistrar.getSecureRandom();
        }
        this.engine.init(forEncryption, param);
        this.forEncryption = forEncryption;
    }

    @Override
    public int getBlockSize() {
        int baseBlockSize = this.engine.getBlockSize();
        if (this.forEncryption) {
            return baseBlockSize - 1 - 2 * this.defHash.length;
        }
        return baseBlockSize;
    }

    @Override
    public int getOutputSize(int inputLen) {
        int baseBlockSize = this.engine.getOutputSize(inputLen);
        if (this.forEncryption) {
            return baseBlockSize;
        }
        return baseBlockSize - 1 - 2 * this.defHash.length;
    }

    @Override
    public byte[] processBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (this.forEncryption) {
            return this.encodeBlock(in, inOff, inLen);
        }
        return this.decodeBlock(in, inOff, inLen);
    }

    public byte[] encodeBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        int i;
        if (inLen > this.getBlockSize()) {
            throw new DataLengthException("input data too long");
        }
        byte[] block = new byte[this.getBlockSize() + 1 + 2 * this.defHash.length];
        System.arraycopy(in, inOff, block, block.length - inLen, inLen);
        block[block.length - inLen - 1] = 1;
        System.arraycopy(this.defHash, 0, block, this.defHash.length, this.defHash.length);
        byte[] seed = new byte[this.defHash.length];
        this.random.nextBytes(seed);
        byte[] mask = this.maskGeneratorFunction1(seed, 0, seed.length, block.length - this.defHash.length);
        for (i = this.defHash.length; i != block.length; ++i) {
            int n = i;
            block[n] = (byte)(block[n] ^ mask[i - this.defHash.length]);
        }
        System.arraycopy(seed, 0, block, 0, this.defHash.length);
        mask = this.maskGeneratorFunction1(block, this.defHash.length, block.length - this.defHash.length, this.defHash.length);
        for (i = 0; i != this.defHash.length; ++i) {
            int n = i;
            block[n] = (byte)(block[n] ^ mask[i]);
        }
        return this.engine.processBlock(block, 0, block.length);
    }

    public byte[] decodeBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        int i;
        boolean wrongData;
        byte[] data = this.engine.processBlock(in, inOff, inLen);
        byte[] block = new byte[this.engine.getOutputSize(inLen)];
        boolean bl = wrongData = block.length < 2 * this.defHash.length + 1;
        if (data.length <= block.length) {
            System.arraycopy(data, 0, block, block.length - data.length, data.length);
        } else {
            System.arraycopy(data, 0, block, 0, block.length);
            wrongData = true;
        }
        byte[] mask = this.maskGeneratorFunction1(block, this.defHash.length, block.length - this.defHash.length, this.defHash.length);
        for (i = 0; i != this.defHash.length; ++i) {
            int n = i;
            block[n] = (byte)(block[n] ^ mask[i]);
        }
        mask = this.maskGeneratorFunction1(block, 0, this.defHash.length, block.length - this.defHash.length);
        for (i = this.defHash.length; i != block.length; ++i) {
            int n = i;
            block[n] = (byte)(block[n] ^ mask[i - this.defHash.length]);
        }
        boolean defHashWrong = false;
        for (int i2 = 0; i2 != this.defHash.length; ++i2) {
            if (this.defHash[i2] == block[this.defHash.length + i2]) continue;
            defHashWrong = true;
        }
        int start = block.length;
        for (int index = 2 * this.defHash.length; index != block.length; ++index) {
            if (!(block[index] != 0 & start == block.length)) continue;
            start = index;
        }
        boolean dataStartWrong = start > block.length - 1 | block[start] != 1;
        ++start;
        if (defHashWrong | wrongData | dataStartWrong) {
            Arrays.fill((byte[])block, (byte)0);
            throw new InvalidCipherTextException("data wrong");
        }
        byte[] output = new byte[block.length - start];
        System.arraycopy(block, start, output, 0, output.length);
        return output;
    }

    private void ItoOSP(int i, byte[] sp) {
        sp[0] = (byte)(i >>> 24);
        sp[1] = (byte)(i >>> 16);
        sp[2] = (byte)(i >>> 8);
        sp[3] = (byte)(i >>> 0);
    }

    private byte[] maskGeneratorFunction1(byte[] Z, int zOff, int zLen, int length) {
        int counter;
        byte[] mask = new byte[length];
        byte[] hashBuf = new byte[this.mgf1Hash.getDigestSize()];
        byte[] C = new byte[4];
        this.mgf1Hash.reset();
        for (counter = 0; counter < length / hashBuf.length; ++counter) {
            this.ItoOSP(counter, C);
            this.mgf1Hash.update(Z, zOff, zLen);
            this.mgf1Hash.update(C, 0, C.length);
            this.mgf1Hash.doFinal(hashBuf, 0);
            System.arraycopy(hashBuf, 0, mask, counter * hashBuf.length, hashBuf.length);
        }
        if (counter * hashBuf.length < length) {
            this.ItoOSP(counter, C);
            this.mgf1Hash.update(Z, zOff, zLen);
            this.mgf1Hash.update(C, 0, C.length);
            this.mgf1Hash.doFinal(hashBuf, 0);
            System.arraycopy(hashBuf, 0, mask, counter * hashBuf.length, mask.length - counter * hashBuf.length);
        }
        return mask;
    }
}

