/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.base.provider;

import com.xdja.jce.base.config.ProviderConfiguration;
import com.xdja.jce.base.provider.config.AlgorithmProvider;
import com.xdja.jce.base.provider.config.AsymmetricKeyInfoConverter;
import com.xdja.jce.base.provider.config.ConfigurableProvider;
import com.xdja.jce.base.provider.config.DeviceProviders;
import com.xdja.jce.base.provider.config.XdjaProviderConfiguration;
import com.xdja.jce.coding.asn1.ASN1ObjectIdentifier;
import com.xdja.jce.coding.asn1.pkcs.PrivateKeyInfo;
import com.xdja.jce.coding.asn1.x509.SubjectPublicKeyInfo;
import com.xdja.jce.core.provider.DeviceProvider;
import com.xdja.jce.core.util.ClassUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XdjaProvider
extends Provider
implements ConfigurableProvider {
    private static Logger logger = LoggerFactory.getLogger(XdjaProvider.class);
    public static final ProviderConfiguration CONFIGURATION = new XdjaProviderConfiguration();
    public static ClassLoader classLoader;
    private static final Map keyInfoConverters;
    public static final String PROVIDER_NAME = "XDJA";
    public static double version;
    public static String info;
    public static final String PROVIDER_PACKAGE_PATH = "com.xdja.jce.crypto.provider";
    public static final String PROVIDER_JAR_SUFFIX = "xdja-jce-crypto-";
    public static List<URL> urls;
    private static final String DIGEST_PACKAGE = "com.xdja.jce.provider.agent.digest.";
    private static final String[] DIGESTS;
    private static final String SYMMETRIC_PACKAGE = "com.xdja.jce.provider.agent.symmetric.";
    private static final String[] SYMMETRIC;
    private static final String ASYMMETRIC_PACKAGE = "com.xdja.jce.provider.agent.asymmetric.";
    private static final String[] ASYMMETRIC;
    private static final String CERT_PACKAGE = "com.xdja.jce.provider.agent.cert.";
    private static final String[] CERT;
    private static final String KEYSTORE_PACKAGE = "com.xdja.jce.provider.agent.keystore.";
    private static final String[] KEYSTORE;
    private static final String RANDOM_PACKAGE = "com.xdja.jce.provider.agent.random.";
    private static final String[] RANDOM;
    private static Set<String> deviceProviderClassName;
    private static Map<String, DeviceProvider> deviceProviderInstance;

    public XdjaProvider() {
        super(PROVIDER_NAME, version, info);
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                XdjaProvider.this.setup();
                return null;
            }
        });
    }

    private void setup() {
        this.configureAlgorithms(DIGEST_PACKAGE, DIGESTS);
        this.configureAlgorithms(SYMMETRIC_PACKAGE, SYMMETRIC);
        this.configureAlgorithms(ASYMMETRIC_PACKAGE, ASYMMETRIC);
        this.configureAlgorithms(CERT_PACKAGE, CERT);
        this.configureAlgorithms(KEYSTORE_PACKAGE, KEYSTORE);
        this.configureAlgorithms(RANDOM_PACKAGE, RANDOM);
        this.put("CertStore.Collection", "com.xdja.jce.base.cert.CertStoreCollectionSpi");
        this.put("CertPathValidator.PKIX", "com.xdja.jce.base.cert.PKIXCertPathValidatorSpi");
        this.put("CertPathBuilder.PKIX", "com.xdja.jce.base.cert.PKIXCertPathBuilderSpi");
        this.configureDeviceProvider();
    }

    public static void addDeviceProvider(String name) {
        if (deviceProviderClassName == null) {
            deviceProviderClassName = new HashSet<String>();
        }
        deviceProviderClassName.add(PROVIDER_PACKAGE_PATH.replace(".", "/") + "/" + name);
    }

    private void configureDeviceProvider() {
        this.doScan();
        this.doLoad();
        this.doConfigure();
    }

    private void doScan() {
        this.doMavenScan(PROVIDER_PACKAGE_PATH);
        this.doJarScan();
        this.doTomcatLibScan();
        this.doAndroidScan();
        if (logger.isDebugEnabled()) {
            logger.debug("\u626b\u63cf\u5230\u7684device provider class\n" + deviceProviderClassName);
            if (null != urls) {
                logger.debug("\u626b\u63cf\u5230\u7684url\n" + urls.stream().map(Object::toString).collect(Collectors.joining(",")));
            }
        }
    }

    private void doAndroidScan() {
    }

    private void doMavenScan(String path) {
        if (null == deviceProviderClassName) {
            deviceProviderClassName = new HashSet<String>();
        }
        Enumeration<URL> resources = null;
        try {
            resources = this.getClass().getClassLoader().getResources(path.replace(".", "/"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        while (resources.hasMoreElements()) {
            File dir;
            URL url = resources.nextElement();
            if (this.checkMavenPackage(url) || !(dir = new File(url.getFile())).exists()) continue;
            for (File file : dir.listFiles()) {
                if (file.isDirectory()) {
                    this.doMavenScan(path + "." + file.getName());
                    continue;
                }
                deviceProviderClassName.add(path + "." + file.getName().replace(".class", "").trim());
            }
        }
    }

    private boolean checkMavenPackage(URL url) {
        if (url.getProtocol().equals("jar")) {
            String path = url.getFile().split("!")[0].substring(6);
            File file = new File(path);
            if (!file.exists()) {
                return false;
            }
            this.addURL(file);
            return true;
        }
        return false;
    }

    private void doJarScan() {
        File file;
        String path = new File("").getAbsolutePath();
        if (logger.isDebugEnabled()) {
            logger.debug("jar\u626b\u63cf\u7684\u8def\u5f84\n" + path);
        }
        if ((file = new File(path)).exists()) {
            this.addScan(file);
        }
    }

    private void doTomcatLibScan() {
        File file;
        URL url = XdjaProvider.class.getClassLoader().getResource("");
        if (null == url) {
            return;
        }
        String path = url.getPath();
        if (logger.isDebugEnabled()) {
            logger.debug("tomcat/lib/\u626b\u63cf\u7684\u8def\u5f84\n" + path);
        }
        if ((file = new File(path)).exists()) {
            this.addScan(file);
        }
    }

    private void addScan(File dir) {
        if (dir.isDirectory() && null != dir.listFiles() && dir.listFiles().length != 0) {
            for (File f : dir.listFiles()) {
                this.addURL(f);
            }
        }
    }

    private void addURL(File f) {
        if (f.getName().startsWith(PROVIDER_JAR_SUFFIX)) {
            if (null == urls) {
                urls = new ArrayList<URL>();
            }
            try {
                urls.add(new URL("file:" + f.getAbsolutePath()));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            deviceProviderClassName.add("com.xdja.jce.crypto.provider." + f.getName().split("-")[3]);
        }
    }

    private void doLoad() {
        if (null == deviceProviderClassName || deviceProviderClassName.size() == 0) {
            return;
        }
        if (null == deviceProviderInstance) {
            deviceProviderInstance = new HashMap<String, DeviceProvider>();
        }
        classLoader = null != urls && urls.size() != 0 ? new URLClassLoader(urls.toArray(new URL[urls.size()]), Thread.currentThread().getContextClassLoader()) : XdjaProvider.class.getClassLoader();
        try {
            for (String className : deviceProviderClassName) {
                String providerName = className.substring(className.lastIndexOf(".") + 1);
                if (deviceProviderInstance.containsKey(providerName)) continue;
                Class<?> clazz = classLoader.loadClass(className);
                if (!DeviceProvider.class.isAssignableFrom(clazz)) {
                    logger.error("load error," + className + "is not subClass of DeviceProvider");
                    continue;
                }
                deviceProviderInstance.put(providerName, (DeviceProvider)clazz.newInstance());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doConfigure() {
        if (null == deviceProviderInstance) {
            return;
        }
        for (String name : deviceProviderInstance.keySet()) {
            deviceProviderInstance.get(name).setup((Provider)this, null);
            DeviceProviders.addDeviceProvider(deviceProviderInstance.get(name));
        }
    }

    private void configureAlgorithms(String packageName, String[] algNames) {
        for (int i = 0; i < algNames.length; ++i) {
            Class clazz = ClassUtil.loadClass(XdjaProvider.class, (String)(packageName + algNames[i] + "$Mappings"));
            if (null != clazz) {
                try {
                    ((AlgorithmProvider)clazz.newInstance()).configure(this);
                    continue;
                }
                catch (Exception e) {
                    throw new InternalError("cannot create instance of " + packageName + algNames[i] + "$Mappings : " + e);
                }
            }
            logger.error("cannot find class of " + packageName + algNames[i] + "$Mappings");
        }
    }

    @Override
    public void setParameter(String parameterName, Object parameter) {
    }

    @Override
    public void addAlgorithm(String key, String value) {
        if (this.containsKey(key)) {
            throw new IllegalStateException("duplicate provider key (" + key + ") found");
        }
        this.put(key, value);
    }

    @Override
    public void addAlgorithm(String type, ASN1ObjectIdentifier oid, String className) {
        this.addAlgorithm(type + "." + oid, className);
        this.addAlgorithm(type + ".OID." + oid, className);
    }

    @Override
    public boolean hasAlgorithm(String type, String name) {
        return this.containsKey(type + "." + name) || this.containsKey("Alg.Alias." + type + "." + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addKeyInfoConverter(ASN1ObjectIdentifier oid, AsymmetricKeyInfoConverter keyInfoConverter) {
        Map map = keyInfoConverters;
        synchronized (map) {
            keyInfoConverters.put(oid, keyInfoConverter);
        }
    }

    @Override
    public void addAttributes(String key, Map<String, String> attributeMap) {
        for (String attributeName : attributeMap.keySet()) {
            String attributeKey = key + " " + attributeName;
            if (this.containsKey(attributeKey)) {
                throw new IllegalStateException("duplicate provider attribute key (" + attributeKey + ") found");
            }
            this.put(attributeKey, attributeMap.get(attributeName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AsymmetricKeyInfoConverter getAsymmetricKeyInfoConverter(ASN1ObjectIdentifier algorithm) {
        Map map = keyInfoConverters;
        synchronized (map) {
            return (AsymmetricKeyInfoConverter)keyInfoConverters.get(algorithm);
        }
    }

    public static PublicKey getPublicKey(SubjectPublicKeyInfo publicKeyInfo) throws IOException {
        AsymmetricKeyInfoConverter converter = XdjaProvider.getAsymmetricKeyInfoConverter(publicKeyInfo.getAlgorithm().getAlgorithm());
        if (converter == null) {
            return null;
        }
        return converter.generatePublic(publicKeyInfo);
    }

    public static PrivateKey getPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        AsymmetricKeyInfoConverter converter = XdjaProvider.getAsymmetricKeyInfoConverter(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm());
        if (converter == null) {
            return null;
        }
        return converter.generatePrivate(privateKeyInfo);
    }

    public static String getMessage() {
        return "XDJA version " + version;
    }

    static {
        keyInfoConverters = new HashMap();
        version = 0.1;
        info = "XDJA Provider v0.1";
        DIGESTS = new String[]{"SM3", "SHA1", "SHA256", "SHA512"};
        SYMMETRIC = new String[]{"SM4", "DESede", "Twofish"};
        ASYMMETRIC = new String[]{"SM2", "EC", "RSA"};
        CERT = new String[]{"X509"};
        KEYSTORE = new String[]{"BKS"};
        RANDOM = new String[]{"Default"};
    }
}

