/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.base.provider.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Config {
    private static String CONFIG_PATH;
    private static final String CONFIG_FINAL_PATH = "/home/xdja/conf/jce/";
    private static final String CONFIG_TOMCAT_PATH = "/conf/jce/";
    private static final String CONFIG_PROVIDER_FILE_NAME = "provider.properties";
    private static final String CONFIG_ALGORITHM_FILE_NAME = "alg.properties";
    private static final String CONFIG_FILE_NAME = "config.properties";
    private static Map<String, String> algorithmConfig;
    private static Map<String, Integer> providerConfig;
    private static Map<String, String> propertyConfig;
    public static final String CIPHER_DEVICE_PROVIDER_VIEW = "cipher.deviceProvider.view";
    public static boolean cipher_device_provider_view;

    private static void init() {
        String flag = Config.getPropertyConfig(CIPHER_DEVICE_PROVIDER_VIEW);
        cipher_device_provider_view = null != flag ? Boolean.valueOf(flag) : false;
    }

    private static void findConfigPath() {
        if (Config.findTomcatPath()) {
            return;
        }
        if (Config.findAndroidPath()) {
            return;
        }
        CONFIG_PATH = CONFIG_FINAL_PATH;
    }

    private static boolean findTomcatPath() {
        String catalinaHome = System.getProperty("catalina.home");
        if (null == catalinaHome) {
            return false;
        }
        CONFIG_PATH = catalinaHome + CONFIG_TOMCAT_PATH;
        return true;
    }

    private static boolean findAndroidPath() {
        return false;
    }

    public boolean isSetProviderConfig() {
        Config.checkInit();
        return this.checkEmpty(providerConfig);
    }

    public boolean isSetAlgorithmConfig() {
        Config.checkInit();
        return this.checkEmpty(algorithmConfig);
    }

    public boolean isSetPropertyConfig() {
        Config.checkInit();
        return this.checkEmpty(propertyConfig);
    }

    private boolean checkEmpty(Map map) {
        return null == map || map.isEmpty();
    }

    public static String getAlgorithmProvider(String algorithm) {
        Config.checkInit();
        if (null == algorithmConfig) {
            return null;
        }
        return algorithmConfig.get(algorithm);
    }

    public static Map<String, Integer> getProviderConfig() {
        Config.checkInit();
        return providerConfig;
    }

    public static String getPropertyConfig(String key) {
        Config.checkInit();
        if (null == propertyConfig) {
            return null;
        }
        return propertyConfig.get(key);
    }

    private static void checkInit() {
        if (null != algorithmConfig && null != providerConfig && null != propertyConfig) {
            return;
        }
        Config.loadConfig();
    }

    private static void loadConfig() {
        providerConfig = Config.doLoadConfig(CONFIG_PATH + CONFIG_PROVIDER_FILE_NAME, true);
        algorithmConfig = Config.doLoadConfig(CONFIG_PATH + CONFIG_ALGORITHM_FILE_NAME, false);
        propertyConfig = Config.doLoadConfig(CONFIG_PATH + CONFIG_FILE_NAME, false);
    }

    private static Map doLoadConfig(String path, boolean valueIsInt) {
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(file));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Enumeration<?> enumeration = properties.propertyNames();
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement().toString();
            String value = properties.getProperty(key);
            map.put(key, valueIsInt ? Integer.valueOf(value) : value);
        }
        return map;
    }

    static {
        Config.findConfigPath();
        Config.init();
    }
}

