/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.base.provider.config;

import com.xdja.jce.base.provider.config.Config;
import com.xdja.jce.core.annotion.OrderComparator;
import com.xdja.jce.core.common.OrderByConfigComparator;
import com.xdja.jce.core.provider.DeviceProvider;
import com.xdja.jce.core.provider.Service;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DeviceProviderList {
    private List<DeviceProvider> deviceProviderList;

    public DeviceProviderList(List<DeviceProvider> deviceProviderList) {
        this.deviceProviderList = deviceProviderList;
    }

    public DeviceProviderList(DeviceProvider deviceProvider) {
        this.deviceProviderList = new ArrayList<DeviceProvider>();
        this.deviceProviderList.add(deviceProvider);
    }

    public List<Service> getServices(String type, String alg) {
        if (null == this.deviceProviderList || this.deviceProviderList.size() == 0) {
            return null;
        }
        ArrayList<Service> services = new ArrayList<Service>();
        for (DeviceProvider provider : this.deviceProviderList) {
            if (null == provider.getService(type, alg)) continue;
            services.add(provider.getService(type, alg));
        }
        return services;
    }

    public DeviceProviderList insert(DeviceProvider deviceProvider) {
        this.deviceProviderList.add(deviceProvider);
        Map<String, Integer> config = Config.getProviderConfig();
        if (null == config || config.isEmpty()) {
            OrderComparator.sort(this.deviceProviderList);
        } else {
            OrderByConfigComparator.sort(this.deviceProviderList, config);
        }
        return new DeviceProviderList(this.deviceProviderList);
    }
}

