/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.base.rsa;

import com.xdja.jce.base.cipher.BaseKeyFactorySpi;
import com.xdja.jce.base.params.AsymmetricKeyParameter;
import com.xdja.jce.base.params.RSAKeyParameters;
import com.xdja.jce.base.params.RSAPrivateCrtKeyParameters;
import com.xdja.jce.base.rsa.BCRSAPrivateCrtKey;
import com.xdja.jce.base.rsa.BCRSAPrivateKey;
import com.xdja.jce.base.rsa.BCRSAPublicKey;
import com.xdja.jce.base.rsa.RSAUtil;
import com.xdja.jce.base.spec.OpenSSHPrivateKeySpec;
import com.xdja.jce.base.spec.OpenSSHPublicKeySpec;
import com.xdja.jce.base.util.ExtendedInvalidKeySpecException;
import com.xdja.jce.base.util.OpenSSHPrivateKeyUtil;
import com.xdja.jce.base.util.OpenSSHPublicKeyUtil;
import com.xdja.jce.coding.asn1.ASN1ObjectIdentifier;
import com.xdja.jce.coding.asn1.pkcs.PrivateKeyInfo;
import com.xdja.jce.coding.asn1.x509.SubjectPublicKeyInfo;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;

public class KeyFactorySpi
extends BaseKeyFactorySpi
implements com.xdja.jce.base.cipher.asymmetric.KeyFactorySpi {
    @Override
    public KeySpec engineGetKeySpec(Key key, Class spec) throws InvalidKeySpecException {
        if (spec.isAssignableFrom(RSAPublicKeySpec.class) && key instanceof RSAPublicKey) {
            RSAPublicKey k = (RSAPublicKey)key;
            return new RSAPublicKeySpec(k.getModulus(), k.getPublicExponent());
        }
        if (spec.isAssignableFrom(RSAPrivateKeySpec.class) && key instanceof RSAPrivateKey) {
            RSAPrivateKey k = (RSAPrivateKey)key;
            return new RSAPrivateKeySpec(k.getModulus(), k.getPrivateExponent());
        }
        if (spec.isAssignableFrom(RSAPrivateCrtKeySpec.class) && key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey k = (RSAPrivateCrtKey)key;
            return new RSAPrivateCrtKeySpec(k.getModulus(), k.getPublicExponent(), k.getPrivateExponent(), k.getPrimeP(), k.getPrimeQ(), k.getPrimeExponentP(), k.getPrimeExponentQ(), k.getCrtCoefficient());
        }
        if (spec.isAssignableFrom(OpenSSHPublicKeySpec.class) && key instanceof RSAPublicKey) {
            try {
                return new OpenSSHPublicKeySpec(OpenSSHPublicKeyUtil.encodePublicKey(new RSAKeyParameters(false, ((RSAPublicKey)key).getModulus(), ((RSAPublicKey)key).getPublicExponent())));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("unable to produce encoding: " + e.getMessage());
            }
        }
        if (spec.isAssignableFrom(OpenSSHPrivateKeySpec.class) && key instanceof RSAPrivateCrtKey) {
            try {
                return new OpenSSHPrivateKeySpec(OpenSSHPrivateKeyUtil.encodePrivateKey(new RSAPrivateCrtKeyParameters(((RSAPrivateCrtKey)key).getModulus(), ((RSAPrivateCrtKey)key).getPublicExponent(), ((RSAPrivateCrtKey)key).getPrivateExponent(), ((RSAPrivateCrtKey)key).getPrimeP(), ((RSAPrivateCrtKey)key).getPrimeQ(), ((RSAPrivateCrtKey)key).getPrimeExponentP(), ((RSAPrivateCrtKey)key).getPrimeExponentQ(), ((RSAPrivateCrtKey)key).getCrtCoefficient())));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("unable to produce encoding: " + e.getMessage());
            }
        }
        if (spec.isAssignableFrom(OpenSSHPublicKeySpec.class) && key instanceof RSAPublicKey) {
            try {
                return new OpenSSHPublicKeySpec(OpenSSHPublicKeyUtil.encodePublicKey(new RSAKeyParameters(false, ((RSAPublicKey)key).getModulus(), ((RSAPublicKey)key).getPublicExponent())));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("unable to produce encoding: " + e.getMessage());
            }
        }
        if (spec.isAssignableFrom(OpenSSHPrivateKeySpec.class) && key instanceof RSAPrivateCrtKey) {
            try {
                return new OpenSSHPrivateKeySpec(OpenSSHPrivateKeyUtil.encodePrivateKey(new RSAPrivateCrtKeyParameters(((RSAPrivateCrtKey)key).getModulus(), ((RSAPrivateCrtKey)key).getPublicExponent(), ((RSAPrivateCrtKey)key).getPrivateExponent(), ((RSAPrivateCrtKey)key).getPrimeP(), ((RSAPrivateCrtKey)key).getPrimeQ(), ((RSAPrivateCrtKey)key).getPrimeExponentP(), ((RSAPrivateCrtKey)key).getPrimeExponentQ(), ((RSAPrivateCrtKey)key).getCrtCoefficient())));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("unable to produce encoding: " + e.getMessage());
            }
        }
        return super.engineGetKeySpec(key, spec);
    }

    @Override
    public Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof RSAPublicKey) {
            return new BCRSAPublicKey((RSAPublicKey)key);
        }
        if (key instanceof RSAPrivateCrtKey) {
            return new BCRSAPrivateCrtKey((RSAPrivateCrtKey)key);
        }
        if (key instanceof RSAPrivateKey) {
            return new BCRSAPrivateKey((RSAPrivateKey)key);
        }
        throw new InvalidKeyException("key type unknown");
    }

    @Override
    public PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                return this.generatePrivate(PrivateKeyInfo.getInstance((Object)((PKCS8EncodedKeySpec)keySpec).getEncoded()));
            }
            catch (Exception e) {
                try {
                    return new BCRSAPrivateCrtKey(com.xdja.jce.coding.asn1.pkcs.RSAPrivateKey.getInstance((Object)((PKCS8EncodedKeySpec)keySpec).getEncoded()));
                }
                catch (Exception ex) {
                    throw new ExtendedInvalidKeySpecException("unable to process key spec: " + e.toString(), e);
                }
            }
        }
        if (keySpec instanceof RSAPrivateCrtKeySpec) {
            return new BCRSAPrivateCrtKey((RSAPrivateCrtKeySpec)keySpec);
        }
        if (keySpec instanceof RSAPrivateKeySpec) {
            return new BCRSAPrivateKey((RSAPrivateKeySpec)keySpec);
        }
        if (keySpec instanceof OpenSSHPrivateKeySpec) {
            AsymmetricKeyParameter parameters = OpenSSHPrivateKeyUtil.parsePrivateKeyBlob(((OpenSSHPrivateKeySpec)keySpec).getEncoded());
            if (parameters instanceof RSAPrivateCrtKeyParameters) {
                return new BCRSAPrivateCrtKey((RSAPrivateCrtKeyParameters)parameters);
            }
            throw new InvalidKeySpecException("open SSH public key is not RSA private key");
        }
        throw new InvalidKeySpecException("unknown KeySpec type: " + keySpec.getClass().getName());
    }

    @Override
    public PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof RSAPublicKeySpec) {
            return new BCRSAPublicKey((RSAPublicKeySpec)keySpec);
        }
        if (keySpec instanceof OpenSSHPublicKeySpec) {
            AsymmetricKeyParameter parameters = OpenSSHPublicKeyUtil.parsePublicKey(((OpenSSHPublicKeySpec)keySpec).getEncoded());
            if (parameters instanceof RSAKeyParameters) {
                return new BCRSAPublicKey((RSAKeyParameters)parameters);
            }
            throw new InvalidKeySpecException("Open SSH public key is not RSA public key");
        }
        return super.engineGeneratePublic(keySpec);
    }

    @Override
    public PrivateKey generatePrivate(PrivateKeyInfo keyInfo) throws IOException {
        ASN1ObjectIdentifier algOid = keyInfo.getPrivateKeyAlgorithm().getAlgorithm();
        if (RSAUtil.isRsaOid(algOid)) {
            com.xdja.jce.coding.asn1.pkcs.RSAPrivateKey rsaPrivKey = com.xdja.jce.coding.asn1.pkcs.RSAPrivateKey.getInstance((Object)keyInfo.parsePrivateKey());
            if (rsaPrivKey.getCoefficient().intValue() == 0) {
                return new BCRSAPrivateKey(keyInfo.getPrivateKeyAlgorithm(), rsaPrivKey);
            }
            return new BCRSAPrivateCrtKey(keyInfo);
        }
        throw new IOException("algorithm identifier " + algOid + " in key not recognised");
    }

    @Override
    public PublicKey generatePublic(SubjectPublicKeyInfo keyInfo) throws IOException {
        ASN1ObjectIdentifier algOid = keyInfo.getAlgorithm().getAlgorithm();
        if (RSAUtil.isRsaOid(algOid)) {
            return new BCRSAPublicKey(keyInfo);
        }
        throw new IOException("algorithm identifier " + algOid + " in key not recognised");
    }
}

