/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.base.util;

import com.xdja.jce.base.provider.XdjaProvider;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CertPathUtils {
    public static final String CERT_PATH_ENCODING_PkiPath = "PkiPath";
    public static final String CERT_PATH_ENCODING_PKCS12 = "PKCS12";
    public static final String CERT_PATH_ENCODING_PKCS7 = "PKCS7";
    public static final String CERT_PATH_ENCODING_CRT = "CRT";
    public static final String CERT_PATH_ENCODING_PEM = "PEM";
    public static final String KEYSTORE_TYPE_BKS = "BKS";
    public static final String KEYSTORE_TYPE_PKCS12 = "PKCS12";
    public static final String KEYSTORE_TYPE_JKS = "JKS";

    public static boolean checkSupportType(String type) {
        return CERT_PATH_ENCODING_PKCS7.equalsIgnoreCase(type) || CERT_PATH_ENCODING_CRT.equalsIgnoreCase(type) || CERT_PATH_ENCODING_PEM.equalsIgnoreCase(type) || CERT_PATH_ENCODING_PkiPath.equalsIgnoreCase(type);
    }

    public static byte[] generateCertPath(List<X509Certificate> certificates, String encoding) throws CertificateException, NoSuchProviderException {
        if (CERT_PATH_ENCODING_CRT.equalsIgnoreCase(encoding)) {
            encoding = CERT_PATH_ENCODING_PEM;
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "XDJA");
        CertPath certPath = cf.generateCertPath(certificates);
        return certPath.getEncoded(encoding);
    }

    public static byte[] generateP7b(List<X509Certificate> certificates) throws CertificateException, NoSuchProviderException {
        return CertPathUtils.generateCertPath(certificates, CERT_PATH_ENCODING_PKCS7);
    }

    public static byte[] generateCrt(List<X509Certificate> certificates) throws CertificateException, NoSuchProviderException {
        return CertPathUtils.generateCertPath(certificates, CERT_PATH_ENCODING_PEM);
    }

    public static List<X509Certificate> readCertificatesFromCrt(InputStream inputStream) throws CertificateException, NoSuchProviderException, IOException {
        return CertPathUtils.readCertificatesFromCertPath(inputStream);
    }

    public static List<X509Certificate> readCertificatesFromP7b(InputStream inputStream) throws CertificateException, IOException, NoSuchProviderException {
        return CertPathUtils.readCertificatesFromCrt(inputStream);
    }

    public static List<X509Certificate> readCertificatesFromCertPath(InputStream inputStream) throws CertificateException, NoSuchProviderException, IOException {
        ArrayList<X509Certificate> certificateList = new ArrayList<X509Certificate>();
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "XDJA");
        Collection<? extends Certificate> certificates = cf.generateCertificates(inputStream);
        for (Certificate certificate : certificates) {
            certificateList.add((X509Certificate)certificate);
        }
        inputStream.close();
        return certificateList;
    }

    static {
        if (Security.getProvider("XDJA") == null) {
            Security.addProvider(new XdjaProvider());
        }
    }
}

