/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.base.util;

import com.xdja.jce.base.nist.NISTNamedCurves;
import com.xdja.jce.base.params.AsymmetricKeyParameter;
import com.xdja.jce.base.params.DSAParameters;
import com.xdja.jce.base.params.DSAPrivateKeyParameters;
import com.xdja.jce.base.params.ECDomainParameters;
import com.xdja.jce.base.params.ECNamedDomainParameters;
import com.xdja.jce.base.params.ECPrivateKeyParameters;
import com.xdja.jce.base.params.RSAPrivateCrtKeyParameters;
import com.xdja.jce.base.util.OpenSSHPublicKeyUtil;
import com.xdja.jce.base.util.PrivateKeyInfoFactory;
import com.xdja.jce.base.util.SSHBuffer;
import com.xdja.jce.base.util.SSHNamedCurves;
import com.xdja.jce.base.x9.ECNamedCurveTable;
import com.xdja.jce.base.x9.X9ECParameters;
import com.xdja.jce.coding.asn1.ASN1Encodable;
import com.xdja.jce.coding.asn1.ASN1EncodableVector;
import com.xdja.jce.coding.asn1.ASN1Integer;
import com.xdja.jce.coding.asn1.ASN1ObjectIdentifier;
import com.xdja.jce.coding.asn1.ASN1Sequence;
import com.xdja.jce.coding.asn1.ASN1TaggedObject;
import com.xdja.jce.coding.asn1.DERSequence;
import com.xdja.jce.coding.asn1.pkcs.PrivateKeyInfo;
import com.xdja.jce.coding.asn1.pkcs.RSAPrivateKey;
import com.xdja.jce.coding.asn1.sec.ECPrivateKey;
import com.xdja.jce.core.util.BigIntegers;
import com.xdja.jce.core.util.Strings;
import java.io.IOException;
import java.math.BigInteger;

public class OpenSSHPrivateKeyUtil {
    static final byte[] AUTH_MAGIC = Strings.toByteArray((String)"openssh-key-v1\u0000");

    private OpenSSHPrivateKeyUtil() {
    }

    public static byte[] encodePrivateKey(AsymmetricKeyParameter params) throws IOException {
        if (params == null) {
            throw new IllegalArgumentException("param is null");
        }
        if (params instanceof RSAPrivateCrtKeyParameters) {
            PrivateKeyInfo pInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(params);
            return pInfo.parsePrivateKey().toASN1Primitive().getEncoded();
        }
        if (params instanceof ECPrivateKeyParameters) {
            PrivateKeyInfo pInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(params);
            return pInfo.parsePrivateKey().toASN1Primitive().getEncoded();
        }
        if (params instanceof DSAPrivateKeyParameters) {
            DSAPrivateKeyParameters dsaPrivKey = (DSAPrivateKeyParameters)params;
            DSAParameters dsaParams = dsaPrivKey.getParameters();
            ASN1EncodableVector vec = new ASN1EncodableVector();
            vec.add((ASN1Encodable)new ASN1Integer(0L));
            vec.add((ASN1Encodable)new ASN1Integer(dsaParams.getP()));
            vec.add((ASN1Encodable)new ASN1Integer(dsaParams.getQ()));
            vec.add((ASN1Encodable)new ASN1Integer(dsaParams.getG()));
            BigInteger pubKey = dsaParams.getG().modPow(dsaPrivKey.getX(), dsaParams.getP());
            vec.add((ASN1Encodable)new ASN1Integer(pubKey));
            vec.add((ASN1Encodable)new ASN1Integer(dsaPrivKey.getX()));
            try {
                return new DERSequence(vec).getEncoded();
            }
            catch (Exception ex) {
                throw new IllegalStateException("unable to encode DSAPrivateKeyParameters " + ex.getMessage());
            }
        }
        throw new IllegalArgumentException("unable to convert " + params.getClass().getName() + " to openssh private key");
    }

    public static AsymmetricKeyParameter parsePrivateKeyBlob(byte[] blob) {
        AsymmetricKeyParameter result = null;
        if (blob[0] == 48) {
            ASN1Sequence sequence = ASN1Sequence.getInstance((Object)blob);
            if (sequence.size() == 6) {
                if (OpenSSHPrivateKeyUtil.allIntegers(sequence) && ((ASN1Integer)sequence.getObjectAt(0)).getPositiveValue().equals(BigIntegers.ZERO)) {
                    result = new DSAPrivateKeyParameters(((ASN1Integer)sequence.getObjectAt(5)).getPositiveValue(), new DSAParameters(((ASN1Integer)sequence.getObjectAt(1)).getPositiveValue(), ((ASN1Integer)sequence.getObjectAt(2)).getPositiveValue(), ((ASN1Integer)sequence.getObjectAt(3)).getPositiveValue()));
                }
            } else if (sequence.size() == 9) {
                if (OpenSSHPrivateKeyUtil.allIntegers(sequence) && ((ASN1Integer)sequence.getObjectAt(0)).getPositiveValue().equals(BigIntegers.ZERO)) {
                    RSAPrivateKey rsaPrivateKey = RSAPrivateKey.getInstance((Object)sequence);
                    result = new RSAPrivateCrtKeyParameters(rsaPrivateKey.getModulus(), rsaPrivateKey.getPublicExponent(), rsaPrivateKey.getPrivateExponent(), rsaPrivateKey.getPrime1(), rsaPrivateKey.getPrime2(), rsaPrivateKey.getExponent1(), rsaPrivateKey.getExponent2(), rsaPrivateKey.getCoefficient());
                }
            } else if (sequence.size() == 4 && sequence.getObjectAt(3) instanceof ASN1TaggedObject && sequence.getObjectAt(2) instanceof ASN1TaggedObject) {
                ECPrivateKey ecPrivateKey = ECPrivateKey.getInstance((Object)sequence);
                ASN1ObjectIdentifier curveOID = (ASN1ObjectIdentifier)ecPrivateKey.getParameters();
                X9ECParameters x9Params = ECNamedCurveTable.getByOID(curveOID);
                result = new ECPrivateKeyParameters(ecPrivateKey.getKey(), (ECDomainParameters)new ECNamedDomainParameters(curveOID, x9Params.getCurve(), x9Params.getG(), x9Params.getN(), x9Params.getH(), x9Params.getSeed()));
            }
        } else {
            int check2;
            SSHBuffer kIn = new SSHBuffer(AUTH_MAGIC, blob);
            String cipherName = kIn.readString();
            if (!"none".equals(cipherName)) {
                throw new IllegalStateException("encrypted keys not supported");
            }
            kIn.skipBlock();
            kIn.skipBlock();
            int publicKeyCount = kIn.readU32();
            if (publicKeyCount != 1) {
                throw new IllegalStateException("multiple keys not supported");
            }
            OpenSSHPublicKeyUtil.parsePublicKey(kIn.readBlock());
            byte[] privateKeyBlock = kIn.readPaddedBlock();
            if (kIn.hasRemaining()) {
                throw new IllegalArgumentException("decoded key has trailing data");
            }
            SSHBuffer pkIn = new SSHBuffer(privateKeyBlock);
            int check1 = pkIn.readU32();
            if (check1 != (check2 = pkIn.readU32())) {
                throw new IllegalStateException("private key check values are not the same");
            }
            String keyType = pkIn.readString();
            if (keyType.startsWith("ecdsa")) {
                ASN1ObjectIdentifier oid = SSHNamedCurves.getByName(Strings.fromByteArray((byte[])pkIn.readBlock()));
                if (oid == null) {
                    throw new IllegalStateException("OID not found for: " + keyType);
                }
                X9ECParameters curveParams = NISTNamedCurves.getByOID(oid);
                if (curveParams == null) {
                    throw new IllegalStateException("Curve not found for: " + oid);
                }
                pkIn.readBlock();
                byte[] privKey = pkIn.readBlock();
                result = new ECPrivateKeyParameters(new BigInteger(1, privKey), (ECDomainParameters)new ECNamedDomainParameters(oid, curveParams.getCurve(), curveParams.getG(), curveParams.getN(), curveParams.getH(), curveParams.getSeed()));
            }
            pkIn.skipBlock();
            if (pkIn.hasRemaining()) {
                throw new IllegalArgumentException("private key block has trailing data");
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("unable to parse key");
        }
        return result;
    }

    private static boolean allIntegers(ASN1Sequence sequence) {
        for (int t = 0; t < sequence.size(); ++t) {
            if (sequence.getObjectAt(t) instanceof ASN1Integer) continue;
            return false;
        }
        return true;
    }
}

