/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.base.x9;

import com.xdja.jce.base.ec.ECAlgorithms;
import com.xdja.jce.base.ec.ECCurve;
import com.xdja.jce.base.x9.X9FieldElement;
import com.xdja.jce.base.x9.X9FieldID;
import com.xdja.jce.base.x9.X9ObjectIdentifiers;
import com.xdja.jce.coding.asn1.ASN1Encodable;
import com.xdja.jce.coding.asn1.ASN1EncodableVector;
import com.xdja.jce.coding.asn1.ASN1Integer;
import com.xdja.jce.coding.asn1.ASN1Object;
import com.xdja.jce.coding.asn1.ASN1ObjectIdentifier;
import com.xdja.jce.coding.asn1.ASN1OctetString;
import com.xdja.jce.coding.asn1.ASN1Primitive;
import com.xdja.jce.coding.asn1.ASN1Sequence;
import com.xdja.jce.coding.asn1.DERBitString;
import com.xdja.jce.coding.asn1.DERSequence;
import com.xdja.jce.core.util.Arrays;
import java.math.BigInteger;

public class X9Curve
extends ASN1Object
implements X9ObjectIdentifiers {
    private ECCurve curve;
    private byte[] seed;
    private ASN1ObjectIdentifier fieldIdentifier = null;

    public X9Curve(ECCurve curve) {
        this(curve, null);
    }

    public X9Curve(ECCurve curve, byte[] seed) {
        this.curve = curve;
        this.seed = Arrays.clone((byte[])seed);
        this.setFieldIdentifier();
    }

    public X9Curve(X9FieldID fieldID, BigInteger order, BigInteger cofactor, ASN1Sequence seq) {
        this.fieldIdentifier = fieldID.getIdentifier();
        if (this.fieldIdentifier.equals((ASN1Primitive)prime_field)) {
            BigInteger p = ((ASN1Integer)fieldID.getParameters()).getValue();
            BigInteger A = new BigInteger(1, ASN1OctetString.getInstance((Object)seq.getObjectAt(0)).getOctets());
            BigInteger B = new BigInteger(1, ASN1OctetString.getInstance((Object)seq.getObjectAt(1)).getOctets());
            this.curve = new ECCurve.Fp(p, A, B, order, cofactor);
        } else if (this.fieldIdentifier.equals((ASN1Primitive)characteristic_two_field)) {
            ASN1Sequence parameters = ASN1Sequence.getInstance((Object)fieldID.getParameters());
            int m = ((ASN1Integer)parameters.getObjectAt(0)).intValueExact();
            ASN1ObjectIdentifier representation = (ASN1ObjectIdentifier)parameters.getObjectAt(1);
            int k1 = 0;
            int k2 = 0;
            int k3 = 0;
            if (representation.equals((ASN1Primitive)tpBasis)) {
                k1 = ASN1Integer.getInstance((Object)parameters.getObjectAt(2)).intValueExact();
            } else if (representation.equals((ASN1Primitive)ppBasis)) {
                ASN1Sequence pentanomial = ASN1Sequence.getInstance((Object)parameters.getObjectAt(2));
                k1 = ASN1Integer.getInstance((Object)pentanomial.getObjectAt(0)).intValueExact();
                k2 = ASN1Integer.getInstance((Object)pentanomial.getObjectAt(1)).intValueExact();
                k3 = ASN1Integer.getInstance((Object)pentanomial.getObjectAt(2)).intValueExact();
            } else {
                throw new IllegalArgumentException("This type of EC basis is not implemented");
            }
            BigInteger A = new BigInteger(1, ASN1OctetString.getInstance((Object)seq.getObjectAt(0)).getOctets());
            BigInteger B = new BigInteger(1, ASN1OctetString.getInstance((Object)seq.getObjectAt(1)).getOctets());
            this.curve = new ECCurve.F2m(m, k1, k2, k3, A, B, order, cofactor);
        } else {
            throw new IllegalArgumentException("This type of ECCurve is not implemented");
        }
        if (seq.size() == 3) {
            this.seed = ((DERBitString)seq.getObjectAt(2)).getBytes();
        }
    }

    private void setFieldIdentifier() {
        if (ECAlgorithms.isFpCurve(this.curve)) {
            this.fieldIdentifier = prime_field;
        } else if (ECAlgorithms.isF2mCurve(this.curve)) {
            this.fieldIdentifier = characteristic_two_field;
        } else {
            throw new IllegalArgumentException("This type of ECCurve is not implemented");
        }
    }

    public ECCurve getCurve() {
        return this.curve;
    }

    public byte[] getSeed() {
        return Arrays.clone((byte[])this.seed);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(3);
        if (this.fieldIdentifier.equals((ASN1Primitive)prime_field)) {
            v.add((ASN1Encodable)new X9FieldElement(this.curve.getA()).toASN1Primitive());
            v.add((ASN1Encodable)new X9FieldElement(this.curve.getB()).toASN1Primitive());
        } else if (this.fieldIdentifier.equals((ASN1Primitive)characteristic_two_field)) {
            v.add((ASN1Encodable)new X9FieldElement(this.curve.getA()).toASN1Primitive());
            v.add((ASN1Encodable)new X9FieldElement(this.curve.getB()).toASN1Primitive());
        }
        if (this.seed != null) {
            v.add((ASN1Encodable)new DERBitString(this.seed));
        }
        return new DERSequence(v);
    }
}

