/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.coding.asn1;

import com.xdja.jce.coding.asn1.ASN1ApplicationSpecificParser;
import com.xdja.jce.coding.asn1.ASN1Encodable;
import com.xdja.jce.coding.asn1.ASN1Exception;
import com.xdja.jce.coding.asn1.ASN1OutputStream;
import com.xdja.jce.coding.asn1.ASN1Primitive;
import com.xdja.jce.coding.asn1.ASN1TaggedObject;
import com.xdja.jce.coding.asn1.DERApplicationSpecific;
import com.xdja.jce.coding.asn1.DLApplicationSpecific;
import java.io.IOException;

public abstract class ASN1ApplicationSpecific
extends ASN1Primitive
implements ASN1ApplicationSpecificParser {
    final ASN1TaggedObject taggedObject;

    ASN1ApplicationSpecific(ASN1TaggedObject taggedObject) {
        ASN1ApplicationSpecific.checkTagClass(taggedObject.getTagClass());
        this.taggedObject = taggedObject;
    }

    public static ASN1ApplicationSpecific getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1ApplicationSpecific) {
            return (ASN1ApplicationSpecific)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return ASN1ApplicationSpecific.getInstance(ASN1Primitive.fromByteArray((byte[])obj));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to construct object from byte[]: " + e.getMessage());
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }

    protected static int getLengthOfHeader(byte[] data) {
        int length = data[1] & 0xFF;
        if (length == 128) {
            return 2;
        }
        if (length > 127) {
            int size = length & 0x7F;
            if (size > 4) {
                throw new IllegalStateException("DER length more than 4 bytes: " + size);
            }
            return size + 2;
        }
        return 2;
    }

    public int getApplicationTag() {
        return this.taggedObject.getTagNo();
    }

    public byte[] getContents() {
        return this.taggedObject.getContents();
    }

    @Override
    public final ASN1Primitive getLoadedObject() {
        return this;
    }

    public ASN1Primitive getObject() throws IOException {
        return this.getEnclosedObject();
    }

    public ASN1Primitive getEnclosedObject() throws IOException {
        return this.taggedObject.obj.toASN1Primitive();
    }

    public ASN1Primitive getObject(int tagNo) throws IOException {
        return this.taggedObject.getBaseUniversal(false, tagNo);
    }

    @Override
    public ASN1Encodable getObjectParser(int tag, boolean isExplicit) throws IOException {
        throw new ASN1Exception("this method only valid for CONTEXT_SPECIFIC tags");
    }

    @Override
    public ASN1Encodable parseBaseUniversal(boolean declaredExplicit, int baseTagNo) throws IOException {
        return this.taggedObject.parseBaseUniversal(declaredExplicit, baseTagNo);
    }

    @Override
    public int getTagClass() {
        return this.taggedObject.getTagClass();
    }

    @Override
    public int getTagNo() {
        return this.taggedObject.getTagNo();
    }

    public boolean hasApplicationTag(int tagNo) {
        return this.taggedObject.hasTag(64, tagNo);
    }

    @Override
    public boolean hasContextTag(int tagNo) {
        return this.taggedObject.hasContextTag(tagNo);
    }

    @Override
    public boolean hasTag(int tagClass, int tagNo) {
        return this.taggedObject.hasTag(tagClass, tagNo);
    }

    public ASN1TaggedObject getTaggedObject() {
        return this.taggedObject;
    }

    @Override
    boolean asn1Equals(ASN1Primitive o) {
        ASN1TaggedObject that;
        if (o instanceof ASN1ApplicationSpecific) {
            that = ((ASN1ApplicationSpecific)o).taggedObject;
        } else if (o instanceof ASN1TaggedObject) {
            that = (ASN1TaggedObject)o;
        } else {
            return false;
        }
        return this.taggedObject.equals(that);
    }

    @Override
    public int hashCode() {
        return this.taggedObject.hashCode();
    }

    @Override
    public boolean isConstructed() {
        return this.taggedObject.isConstructed();
    }

    @Override
    public ASN1Encodable readObject() throws IOException {
        return this.taggedObject.obj.toASN1Primitive();
    }

    @Override
    int encodedLength(boolean withTag) throws IOException {
        return this.taggedObject.encodedLength(withTag);
    }

    @Override
    void encode(ASN1OutputStream out, boolean withTag) throws IOException {
        this.taggedObject.encode(out, withTag);
    }

    @Override
    ASN1Primitive toDERObject() {
        return new DERApplicationSpecific((ASN1TaggedObject)this.taggedObject.toDERObject());
    }

    @Override
    ASN1Primitive toDLObject() {
        return new DLApplicationSpecific((ASN1TaggedObject)this.taggedObject.toDLObject());
    }

    private static int checkTagClass(int tagClass) {
        if (64 != tagClass) {
            throw new IllegalArgumentException();
        }
        return tagClass;
    }
}

