/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.coding.asn1;

import com.xdja.jce.coding.asn1.ASN1Encodable;
import com.xdja.jce.coding.asn1.ASN1Integer;
import com.xdja.jce.coding.asn1.ASN1ObjectIdentifier;
import com.xdja.jce.coding.asn1.ASN1Primitive;
import com.xdja.jce.coding.asn1.ASN1Sequence;
import com.xdja.jce.coding.asn1.ASN1TaggedObject;
import com.xdja.jce.coding.asn1.ASN1UniversalType;
import com.xdja.jce.coding.asn1.DERExternal;
import com.xdja.jce.coding.asn1.DERTaggedObject;
import com.xdja.jce.coding.asn1.DLExternal;

public abstract class ASN1External
extends ASN1Primitive {
    static final ASN1UniversalType TYPE = new ASN1UniversalType(ASN1External.class, 8){

        @Override
        ASN1Primitive fromImplicitConstructed(ASN1Sequence sequence) {
            return sequence.toASN1External();
        }
    };
    ASN1ObjectIdentifier directReference;
    ASN1Integer indirectReference;
    ASN1Primitive dataValueDescriptor;
    int encoding;
    ASN1Primitive externalContent;

    public static ASN1External getInstance(Object obj) {
        ASN1Primitive primitive;
        if (obj == null || obj instanceof ASN1External) {
            return (ASN1External)obj;
        }
        if (obj instanceof ASN1Encodable && (primitive = ((ASN1Encodable)obj).toASN1Primitive()) instanceof ASN1External) {
            return (ASN1External)primitive;
        }
        if (obj instanceof byte[]) {
            try {
                return (ASN1External)TYPE.fromByteArray((byte[])obj);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("encoding error in getInstance: " + e.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1External getInstance(ASN1TaggedObject taggedObject, boolean explicit) {
        return (ASN1External)TYPE.getContextInstance(taggedObject, explicit);
    }

    ASN1External(ASN1Sequence sequence) {
        int offset = 0;
        ASN1Primitive enc = ASN1External.getObjFromSequence(sequence, offset);
        if (enc instanceof ASN1ObjectIdentifier) {
            this.directReference = (ASN1ObjectIdentifier)enc;
            enc = ASN1External.getObjFromSequence(sequence, ++offset);
        }
        if (enc instanceof ASN1Integer) {
            this.indirectReference = (ASN1Integer)enc;
            enc = ASN1External.getObjFromSequence(sequence, ++offset);
        }
        if (!(enc instanceof ASN1TaggedObject)) {
            this.dataValueDescriptor = enc;
            enc = ASN1External.getObjFromSequence(sequence, ++offset);
        }
        if (sequence.size() != offset + 1) {
            throw new IllegalArgumentException("input vector too large");
        }
        if (!(enc instanceof ASN1TaggedObject)) {
            throw new IllegalArgumentException("No tagged object found in vector. Structure doesn't seem to be of type External");
        }
        ASN1TaggedObject obj = (ASN1TaggedObject)enc;
        this.setEncoding(obj.getTagNo());
        this.externalContent = obj.getObject();
    }

    ASN1External(ASN1ObjectIdentifier directReference, ASN1Integer indirectReference, ASN1Primitive dataValueDescriptor, DERTaggedObject externalData) {
        this(directReference, indirectReference, dataValueDescriptor, externalData.getTagNo(), externalData.toASN1Primitive());
    }

    ASN1External(ASN1ObjectIdentifier directReference, ASN1Integer indirectReference, ASN1Primitive dataValueDescriptor, int encoding, ASN1Primitive externalData) {
        this.setDirectReference(directReference);
        this.setIndirectReference(indirectReference);
        this.setDataValueDescriptor(dataValueDescriptor);
        this.setEncoding(encoding);
        this.setExternalContent(externalData.toASN1Primitive());
    }

    @Override
    ASN1Primitive toDERObject() {
        return new DERExternal(this.directReference, this.indirectReference, this.dataValueDescriptor, this.encoding, this.externalContent);
    }

    @Override
    ASN1Primitive toDLObject() {
        return new DLExternal(this.directReference, this.indirectReference, this.dataValueDescriptor, this.encoding, this.externalContent);
    }

    @Override
    public int hashCode() {
        int ret = 0;
        if (this.directReference != null) {
            ret = this.directReference.hashCode();
        }
        if (this.indirectReference != null) {
            ret ^= this.indirectReference.hashCode();
        }
        if (this.dataValueDescriptor != null) {
            ret ^= this.dataValueDescriptor.hashCode();
        }
        return ret ^= this.externalContent.hashCode();
    }

    @Override
    boolean isConstructed() {
        return true;
    }

    @Override
    boolean asn1Equals(ASN1Primitive o) {
        if (!(o instanceof ASN1External)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        ASN1External other = (ASN1External)o;
        if (!(this.directReference == null || other.directReference != null && other.directReference.equals(this.directReference))) {
            return false;
        }
        if (!(this.indirectReference == null || other.indirectReference != null && other.indirectReference.equals(this.indirectReference))) {
            return false;
        }
        if (!(this.dataValueDescriptor == null || other.dataValueDescriptor != null && other.dataValueDescriptor.equals(this.dataValueDescriptor))) {
            return false;
        }
        return this.externalContent.equals(other.externalContent);
    }

    public ASN1Primitive getDataValueDescriptor() {
        return this.dataValueDescriptor;
    }

    public ASN1ObjectIdentifier getDirectReference() {
        return this.directReference;
    }

    public int getEncoding() {
        return this.encoding;
    }

    public ASN1Primitive getExternalContent() {
        return this.externalContent;
    }

    public ASN1Integer getIndirectReference() {
        return this.indirectReference;
    }

    private void setDataValueDescriptor(ASN1Primitive dataValueDescriptor) {
        this.dataValueDescriptor = dataValueDescriptor;
    }

    private void setDirectReference(ASN1ObjectIdentifier directReferemce) {
        this.directReference = directReferemce;
    }

    private void setEncoding(int encoding) {
        if (encoding < 0 || encoding > 2) {
            throw new IllegalArgumentException("invalid encoding value: " + encoding);
        }
        this.encoding = encoding;
    }

    private void setExternalContent(ASN1Primitive externalContent) {
        this.externalContent = externalContent;
    }

    private void setIndirectReference(ASN1Integer indirectReference) {
        this.indirectReference = indirectReference;
    }

    private static ASN1Primitive getObjFromSequence(ASN1Sequence sequence, int index) {
        if (sequence.size() <= index) {
            throw new IllegalArgumentException("too few objects in input sequence");
        }
        return sequence.getObjectAt(index).toASN1Primitive();
    }
}

