/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.coding.asn1;

import com.xdja.jce.coding.asn1.ASN1ApplicationSpecific;
import com.xdja.jce.coding.asn1.ASN1BitString;
import com.xdja.jce.coding.asn1.ASN1Choice;
import com.xdja.jce.coding.asn1.ASN1Encodable;
import com.xdja.jce.coding.asn1.ASN1EncodableVector;
import com.xdja.jce.coding.asn1.ASN1Exception;
import com.xdja.jce.coding.asn1.ASN1InputStream;
import com.xdja.jce.coding.asn1.ASN1Object;
import com.xdja.jce.coding.asn1.ASN1OctetString;
import com.xdja.jce.coding.asn1.ASN1OutputStream;
import com.xdja.jce.coding.asn1.ASN1Primitive;
import com.xdja.jce.coding.asn1.ASN1Sequence;
import com.xdja.jce.coding.asn1.ASN1Set;
import com.xdja.jce.coding.asn1.ASN1TaggedObjectParser;
import com.xdja.jce.coding.asn1.ASN1UniversalType;
import com.xdja.jce.coding.asn1.ASN1UniversalTypes;
import com.xdja.jce.coding.asn1.ASN1Util;
import com.xdja.jce.coding.asn1.BERApplicationSpecific;
import com.xdja.jce.coding.asn1.BERFactory;
import com.xdja.jce.coding.asn1.BERTaggedObject;
import com.xdja.jce.coding.asn1.DEROctetString;
import com.xdja.jce.coding.asn1.DERTaggedObject;
import com.xdja.jce.coding.asn1.DLApplicationSpecific;
import com.xdja.jce.coding.asn1.DLFactory;
import com.xdja.jce.coding.asn1.DLTaggedObject;
import com.xdja.jce.core.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public abstract class ASN1TaggedObject
extends ASN1Primitive
implements ASN1TaggedObjectParser {
    private static final int DECLARED_EXPLICIT = 1;
    private static final int DECLARED_IMPLICIT = 2;
    private static final int PARSED_EXPLICIT = 3;
    private static final int PARSED_IMPLICIT = 4;
    final int explicitness;
    final int tagClass;
    final int tagNo;
    final ASN1Encodable obj;

    public static ASN1TaggedObject getInstance(ASN1TaggedObject obj, boolean explicit) {
        if (128 != obj.getTagClass()) {
            throw new IllegalStateException("this method only valid for CONTEXT_SPECIFIC tags");
        }
        if (explicit) {
            return obj.getExplicitBaseTagged();
        }
        throw new IllegalArgumentException("this method not valid for implicitly tagged tagged objects");
    }

    public static ASN1TaggedObject getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1TaggedObject) {
            return (ASN1TaggedObject)obj;
        }
        if (obj instanceof ASN1Encodable) {
            ASN1Primitive primitive = ((ASN1Encodable)obj).toASN1Primitive();
            if (primitive instanceof ASN1TaggedObject) {
                return (ASN1TaggedObject)primitive;
            }
        } else if (obj instanceof byte[]) {
            try {
                return ASN1TaggedObject.getInstance(ASN1TaggedObject.fromByteArray((byte[])obj));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("failed to construct tagged object from byte[]: " + e.getMessage());
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }

    protected ASN1TaggedObject(boolean explicit, int tagNo, ASN1Encodable obj) {
        this(explicit, 128, tagNo, obj);
    }

    protected ASN1TaggedObject(boolean explicit, int tagClass, int tagNo, ASN1Encodable obj) {
        this(explicit ? 1 : 2, tagClass, tagNo, obj);
    }

    ASN1TaggedObject(int explicitness, int tagClass, int tagNo, ASN1Encodable obj) {
        if (null == obj) {
            throw new NullPointerException("'obj' cannot be null");
        }
        if (tagClass == 0 || (tagClass & 0xC0) != tagClass) {
            throw new IllegalArgumentException("invalid tag class: " + tagClass);
        }
        this.explicitness = obj instanceof ASN1Choice ? 1 : explicitness;
        this.tagClass = tagClass;
        this.tagNo = tagNo;
        this.obj = obj;
    }

    @Override
    boolean asn1Equals(ASN1Primitive other) {
        ASN1Primitive p2;
        if (other instanceof ASN1ApplicationSpecific) {
            return other.equals(this);
        }
        if (!(other instanceof ASN1TaggedObject)) {
            return false;
        }
        ASN1TaggedObject that = (ASN1TaggedObject)other;
        if (this.tagNo != that.tagNo || this.tagClass != that.tagClass) {
            return false;
        }
        if (this.explicitness != that.explicitness && this.isExplicit() != that.isExplicit()) {
            return false;
        }
        ASN1Primitive p1 = this.obj.toASN1Primitive();
        if (p1 == (p2 = that.obj.toASN1Primitive())) {
            return true;
        }
        if (!this.isExplicit()) {
            try {
                byte[] d1 = this.getEncoded();
                byte[] d2 = that.getEncoded();
                return Arrays.areEqual((byte[])d1, (byte[])d2);
            }
            catch (IOException e) {
                return false;
            }
        }
        return p1.asn1Equals(p2);
    }

    @Override
    public int hashCode() {
        return this.tagClass * 7919 ^ this.tagNo ^ (this.isExplicit() ? 15 : 240) ^ this.obj.toASN1Primitive().hashCode();
    }

    @Override
    public int getTagClass() {
        return this.tagClass;
    }

    @Override
    public int getTagNo() {
        return this.tagNo;
    }

    @Override
    public boolean hasContextTag(int tagNo) {
        return this.tagClass == 128 && this.tagNo == tagNo;
    }

    @Override
    public boolean hasTag(int tagClass, int tagNo) {
        return this.tagClass == tagClass && this.tagNo == tagNo;
    }

    public boolean isExplicit() {
        switch (this.explicitness) {
            case 1: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    byte[] getContents() {
        try {
            int contentsLength;
            byte[] baseEncoding = this.obj.toASN1Primitive().getEncoded(this.getASN1Encoding());
            if (this.isExplicit()) {
                return baseEncoding;
            }
            ByteArrayInputStream input = new ByteArrayInputStream(baseEncoding);
            int tag = input.read();
            ASN1InputStream.readTagNumber(input, tag);
            int length = ASN1InputStream.readLength(input, input.available(), false);
            int remaining = input.available();
            int n = contentsLength = length < 0 ? remaining - 2 : remaining;
            if (contentsLength < 0) {
                throw new IllegalStateException();
            }
            byte[] contents = new byte[contentsLength];
            System.arraycopy(baseEncoding, baseEncoding.length - remaining, contents, 0, contentsLength);
            return contents;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public ASN1Primitive getObject() {
        if (128 != this.getTagClass()) {
            throw new IllegalStateException("this method only valid for CONTEXT_SPECIFIC tags");
        }
        return this.obj.toASN1Primitive();
    }

    public ASN1Object getExplicitBaseObject() {
        if (!this.isExplicit()) {
            throw new IllegalStateException("object implicit - explicit expected.");
        }
        return this.obj instanceof ASN1Object ? (ASN1Object)this.obj : this.obj.toASN1Primitive();
    }

    public ASN1Object getExplicitContextBaseObject() {
        if (128 != this.getTagClass()) {
            throw new IllegalStateException("this method only valid for CONTEXT_SPECIFIC tags");
        }
        if (!this.isExplicit()) {
            throw new IllegalStateException("object implicit - explicit expected.");
        }
        return this.obj instanceof ASN1Object ? (ASN1Object)this.obj : this.obj.toASN1Primitive();
    }

    public ASN1TaggedObject getExplicitBaseTagged() {
        if (!this.isExplicit()) {
            throw new IllegalStateException("object implicit - explicit expected.");
        }
        return ASN1TaggedObject.checkedCast(this.obj.toASN1Primitive());
    }

    public ASN1TaggedObject getImplicitBaseTagged(int baseTagClass, int baseTagNo) {
        if (baseTagClass == 0 || (baseTagClass & 0xC0) != baseTagClass) {
            throw new IllegalArgumentException("invalid base tag class: " + baseTagClass);
        }
        switch (this.explicitness) {
            case 1: {
                throw new IllegalStateException("object explicit - implicit expected.");
            }
            case 2: {
                ASN1TaggedObject declared = ASN1TaggedObject.checkedCast(this.obj.toASN1Primitive());
                if (!declared.hasTag(baseTagClass, baseTagNo)) {
                    String expected = ASN1Util.getTagText(baseTagClass, baseTagNo);
                    String found = ASN1Util.getTagText(declared);
                    throw new IllegalStateException("Expected " + expected + " tag but found " + found);
                }
                return declared;
            }
        }
        return this.replaceTag(baseTagClass, baseTagNo);
    }

    public ASN1Primitive getBaseUniversal(boolean declaredExplicit, int tagNo) {
        ASN1UniversalType universalType = ASN1UniversalTypes.get(tagNo);
        if (null == universalType) {
            throw new IllegalArgumentException("unsupported UNIVERSAL tag number: " + tagNo);
        }
        if (declaredExplicit) {
            if (!this.isExplicit()) {
                throw new IllegalArgumentException("object implicit - explicit expected.");
            }
            return universalType.checkedCast(this.obj.toASN1Primitive());
        }
        if (1 == this.explicitness) {
            throw new IllegalArgumentException("object explicit - implicit expected.");
        }
        ASN1Primitive primitive = this.obj.toASN1Primitive();
        switch (this.explicitness) {
            case 3: {
                return universalType.fromImplicitConstructed(this.rebuildConstructed(primitive));
            }
            case 4: {
                if (primitive instanceof ASN1Sequence) {
                    return universalType.fromImplicitConstructed((ASN1Sequence)primitive);
                }
                return universalType.fromImplicitPrimitive((DEROctetString)primitive);
            }
        }
        return universalType.checkedCast(primitive);
    }

    @Override
    public ASN1Encodable getObjectParser(int tag, boolean isExplicit) throws IOException {
        if (128 != this.getTagClass()) {
            throw new ASN1Exception("this method only valid for CONTEXT_SPECIFIC tags");
        }
        return this.parseBaseUniversal(isExplicit, tag);
    }

    @Override
    public ASN1Encodable parseBaseUniversal(boolean declaredExplicit, int baseTagNo) throws IOException {
        ASN1Primitive primitive = this.getBaseUniversal(declaredExplicit, baseTagNo);
        switch (baseTagNo) {
            case 3: {
                return ((ASN1BitString)primitive).parser();
            }
            case 4: {
                return ((ASN1OctetString)primitive).parser();
            }
            case 17: {
                return ((ASN1Set)primitive).parser();
            }
            case 16: {
                return ((ASN1Sequence)primitive).parser();
            }
        }
        return primitive;
    }

    @Override
    public final ASN1Primitive getLoadedObject() {
        return this;
    }

    @Override
    final void encode(ASN1OutputStream out, boolean withTag) throws IOException {
        this.encode(out, withTag, this.getTagClass(), this.getTagNo());
    }

    abstract void encode(ASN1OutputStream var1, boolean var2, int var3, int var4) throws IOException;

    abstract String getASN1Encoding();

    abstract ASN1Sequence rebuildConstructed(ASN1Primitive var1);

    abstract ASN1TaggedObject replaceTag(int var1, int var2);

    @Override
    ASN1Primitive toDERObject() {
        return new DERTaggedObject(this.explicitness, this.tagClass, this.tagNo, this.obj);
    }

    @Override
    ASN1Primitive toDLObject() {
        return new DLTaggedObject(this.explicitness, this.tagClass, this.tagNo, this.obj);
    }

    public String toString() {
        return ASN1Util.getTagText(this.tagClass, this.tagNo) + this.obj;
    }

    static ASN1Primitive createConstructed(int tagClass, int tagNo, boolean isIL, ASN1EncodableVector contentsElements) {
        boolean maybeExplicit;
        boolean bl = maybeExplicit = contentsElements.size() == 1;
        if (isIL) {
            BERTaggedObject taggedObject = maybeExplicit ? new BERTaggedObject(3, tagClass, tagNo, contentsElements.get(0)) : new BERTaggedObject(4, tagClass, tagNo, (ASN1Encodable)BERFactory.createSequence(contentsElements));
            switch (tagClass) {
                case 64: {
                    return new BERApplicationSpecific(taggedObject);
                }
            }
            return taggedObject;
        }
        DLTaggedObject taggedObject = maybeExplicit ? new DLTaggedObject(3, tagClass, tagNo, contentsElements.get(0)) : new DLTaggedObject(4, tagClass, tagNo, (ASN1Encodable)DLFactory.createSequence(contentsElements));
        switch (tagClass) {
            case 64: {
                return new DLApplicationSpecific(taggedObject);
            }
        }
        return taggedObject;
    }

    static ASN1Primitive createPrimitive(int tagClass, int tagNo, byte[] contentsOctets) {
        DLTaggedObject taggedObject = new DLTaggedObject(4, tagClass, tagNo, (ASN1Encodable)new DEROctetString(contentsOctets));
        switch (tagClass) {
            case 64: {
                return new DLApplicationSpecific(taggedObject);
            }
        }
        return taggedObject;
    }

    private static ASN1TaggedObject checkedCast(ASN1Primitive primitive) {
        if (primitive instanceof ASN1TaggedObject) {
            return (ASN1TaggedObject)primitive;
        }
        throw new IllegalStateException("unexpected object: " + primitive.getClass().getName());
    }
}

