/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.coding.asn1;

import com.xdja.jce.coding.asn1.ASN1Encodable;
import com.xdja.jce.coding.asn1.ASN1OutputStream;
import com.xdja.jce.coding.asn1.ASN1ParsingException;
import com.xdja.jce.coding.asn1.ASN1Primitive;
import com.xdja.jce.coding.asn1.ASN1String;
import com.xdja.jce.coding.asn1.ASN1TaggedObject;
import com.xdja.jce.coding.asn1.ASN1UniversalType;
import com.xdja.jce.coding.asn1.DEROctetString;
import com.xdja.jce.coding.asn1.DERUniversalString;
import com.xdja.jce.core.util.Arrays;
import java.io.IOException;

public abstract class ASN1UniversalString
extends ASN1Primitive
implements ASN1String {
    static final ASN1UniversalType TYPE = new ASN1UniversalType(ASN1UniversalString.class, 28){

        @Override
        ASN1Primitive fromImplicitPrimitive(DEROctetString octetString) {
            return ASN1UniversalString.createPrimitive(octetString.getOctets());
        }
    };
    private static final char[] table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    final byte[] contents;

    public static ASN1UniversalString getInstance(Object obj) {
        ASN1Primitive primitive;
        if (obj == null || obj instanceof ASN1UniversalString) {
            return (ASN1UniversalString)obj;
        }
        if (obj instanceof ASN1Encodable && (primitive = ((ASN1Encodable)obj).toASN1Primitive()) instanceof ASN1UniversalString) {
            return (ASN1UniversalString)primitive;
        }
        if (obj instanceof byte[]) {
            try {
                return (ASN1UniversalString)TYPE.fromByteArray((byte[])obj);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("encoding error getInstance: " + e.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1UniversalString getInstance(ASN1TaggedObject taggedObject, boolean explicit) {
        return (ASN1UniversalString)TYPE.getContextInstance(taggedObject, explicit);
    }

    ASN1UniversalString(byte[] contents, boolean clone) {
        this.contents = clone ? Arrays.clone((byte[])contents) : contents;
    }

    @Override
    public final String getString() {
        byte[] string;
        StringBuffer buf = new StringBuffer("#");
        try {
            string = this.getEncoded();
        }
        catch (IOException e) {
            throw new ASN1ParsingException("internal error encoding UniversalString");
        }
        for (int i = 0; i != string.length; ++i) {
            buf.append(table[string[i] >>> 4 & 0xF]);
            buf.append(table[string[i] & 0xF]);
        }
        return buf.toString();
    }

    public String toString() {
        return this.getString();
    }

    public final byte[] getOctets() {
        return Arrays.clone((byte[])this.contents);
    }

    @Override
    final boolean isConstructed() {
        return false;
    }

    @Override
    final int encodedLength(boolean withTag) {
        return ASN1OutputStream.getLengthOfEncodingDL(withTag, this.contents.length);
    }

    @Override
    final void encode(ASN1OutputStream out, boolean withTag) throws IOException {
        out.writeEncodingDL(withTag, 28, this.contents);
    }

    @Override
    final boolean asn1Equals(ASN1Primitive other) {
        if (!(other instanceof ASN1UniversalString)) {
            return false;
        }
        ASN1UniversalString that = (ASN1UniversalString)other;
        return Arrays.areEqual((byte[])this.contents, (byte[])that.contents);
    }

    @Override
    public final int hashCode() {
        return Arrays.hashCode((byte[])this.contents);
    }

    static ASN1UniversalString createPrimitive(byte[] contents) {
        return new DERUniversalString(contents, false);
    }
}

