/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.coding.asn1;

import com.xdja.jce.coding.asn1.ASN1Encodable;
import com.xdja.jce.coding.asn1.ASN1Exception;
import com.xdja.jce.coding.asn1.ASN1ParsingException;
import com.xdja.jce.coding.asn1.ASN1Primitive;
import com.xdja.jce.coding.asn1.ASN1StreamParser;
import com.xdja.jce.coding.asn1.ASN1TaggedObjectParser;
import java.io.IOException;

public class BERTaggedObjectParser
implements ASN1TaggedObjectParser {
    private int _tagClass;
    protected int _tagNo;
    private boolean _constructed;
    ASN1StreamParser _parser;

    BERTaggedObjectParser(int tagClass, int tagNo, boolean constructed, ASN1StreamParser parser) {
        this._tagClass = tagClass;
        this._tagNo = tagNo;
        this._constructed = constructed;
        this._parser = parser;
    }

    @Override
    public int getTagClass() {
        return this._tagClass;
    }

    @Override
    public int getTagNo() {
        return this._tagNo;
    }

    @Override
    public boolean hasContextTag(int tagNo) {
        return this._tagClass == 128 && this._tagNo == tagNo;
    }

    @Override
    public boolean hasTag(int tagClass, int tagNo) {
        return this._tagClass == tagClass && this._tagNo == tagNo;
    }

    public boolean isConstructed() {
        return this._constructed;
    }

    @Override
    public ASN1Encodable getObjectParser(int tag, boolean isExplicit) throws IOException {
        if (128 != this.getTagClass()) {
            throw new ASN1Exception("this method only valid for CONTEXT_SPECIFIC tags");
        }
        return this.parseBaseUniversal(isExplicit, tag);
    }

    @Override
    public ASN1Primitive getLoadedObject() throws IOException {
        return this._parser.readTaggedObject(this._tagClass, this._tagNo, this._constructed);
    }

    @Override
    public ASN1Encodable parseBaseUniversal(boolean declaredExplicit, int baseTagNo) throws IOException {
        if (declaredExplicit) {
            if (!this._constructed) {
                throw new IOException("Explicit tags must be constructed (see X.690 8.14.2)");
            }
            return this._parser.readObject();
        }
        return this._parser.readImplicit(this._constructed, baseTagNo);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        try {
            return this.getLoadedObject();
        }
        catch (IOException e) {
            throw new ASN1ParsingException(e.getMessage());
        }
    }
}

