/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.crypto.soft.engine.keypair;

import com.xdja.jce.base.cipher.asymmetric.ECUtils;
import com.xdja.jce.base.cipher.asymmetric.KeyPairGeneratorSpi;
import com.xdja.jce.base.cipher.asymmetric.util.ECUtil;
import com.xdja.jce.base.common.CryptoServicesRegistrar;
import com.xdja.jce.base.common.EC5Util;
import com.xdja.jce.base.config.ProviderConfiguration;
import com.xdja.jce.base.ec.BCECPrivateKey;
import com.xdja.jce.base.ec.BCECPublicKey;
import com.xdja.jce.base.ec.ECCurve;
import com.xdja.jce.base.generators.ECKeyPairGenerator;
import com.xdja.jce.base.key.AsymmetricCipherKeyPair;
import com.xdja.jce.base.params.ECDomainParameters;
import com.xdja.jce.base.params.ECKeyGenerationParameters;
import com.xdja.jce.base.params.ECPrivateKeyParameters;
import com.xdja.jce.base.params.ECPublicKeyParameters;
import com.xdja.jce.base.params.KeyGenerationParameters;
import com.xdja.jce.base.provider.XdjaProvider;
import com.xdja.jce.base.spec.ECNamedCurveGenParameterSpec;
import com.xdja.jce.base.spec.ECNamedCurveSpec;
import com.xdja.jce.base.x9.ECNamedCurveTable;
import com.xdja.jce.base.x9.X9ECParameters;
import com.xdja.jce.coding.asn1.ASN1ObjectIdentifier;
import com.xdja.jce.core.util.Integers;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.Hashtable;
import java.util.Map;

public class ECKeyPairGeneratorEngine
extends KeyPairGeneratorSpi {
    ECKeyGenerationParameters param;
    ECKeyPairGenerator engine = new ECKeyPairGenerator();
    Object ecParams = null;
    int strength = 239;
    SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    boolean initialised = false;
    String algorithm;
    ProviderConfiguration configuration;
    private static Hashtable ecParameters = new Hashtable();

    public ECKeyPairGeneratorEngine() {
        super("EC");
        this.algorithm = "EC";
        this.configuration = XdjaProvider.CONFIGURATION;
    }

    public ECKeyPairGeneratorEngine(String algorithm, ProviderConfiguration configuration) {
        super(algorithm);
        this.algorithm = algorithm;
        this.configuration = configuration;
    }

    public void initialize(int strength, SecureRandom random) {
        this.strength = strength;
        this.random = random;
        ECGenParameterSpec ecParams = (ECGenParameterSpec)ecParameters.get(Integers.valueOf((int)strength));
        if (ecParams == null) {
            throw new InvalidParameterException("unknown key size.");
        }
        try {
            this.initialize(ecParams, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidParameterException("key size not configurable.");
        }
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (params == null) {
            com.xdja.jce.base.spec.ECParameterSpec implicitCA = this.configuration.getEcImplicitlyCa();
            if (implicitCA == null) {
                throw new InvalidAlgorithmParameterException("null parameter passed but no implicitCA set");
            }
            this.ecParams = null;
            this.param = this.createKeyGenParamsBC(implicitCA, random);
        } else if (params instanceof com.xdja.jce.base.spec.ECParameterSpec) {
            this.ecParams = params;
            this.param = this.createKeyGenParamsBC((com.xdja.jce.base.spec.ECParameterSpec)params, random);
        } else if (params instanceof ECParameterSpec) {
            this.ecParams = params;
            this.param = this.createKeyGenParamsJCE((ECParameterSpec)params, random);
        } else if (params instanceof ECGenParameterSpec) {
            this.initializeNamedCurve(((ECGenParameterSpec)params).getName(), random);
        } else if (params instanceof ECNamedCurveGenParameterSpec) {
            this.initializeNamedCurve(((ECNamedCurveGenParameterSpec)params).getName(), random);
        } else {
            String name = ECUtil.getNameFrom((AlgorithmParameterSpec)params);
            if (name != null) {
                this.initializeNamedCurve(name, random);
            } else {
                throw new InvalidAlgorithmParameterException("invalid parameterSpec: " + params);
            }
        }
        this.engine.init((KeyGenerationParameters)this.param);
        this.initialised = true;
    }

    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            this.initialize(this.strength, new SecureRandom());
        }
        AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
        ECPublicKeyParameters pub = (ECPublicKeyParameters)pair.getPublic();
        ECPrivateKeyParameters priv = (ECPrivateKeyParameters)pair.getPrivate();
        if (this.ecParams instanceof com.xdja.jce.base.spec.ECParameterSpec) {
            com.xdja.jce.base.spec.ECParameterSpec p = (com.xdja.jce.base.spec.ECParameterSpec)this.ecParams;
            BCECPublicKey pubKey = new BCECPublicKey(this.algorithm, pub, p, this.configuration);
            return new KeyPair((PublicKey)pubKey, (PrivateKey)new BCECPrivateKey(this.algorithm, priv, pubKey, p, this.configuration));
        }
        if (this.ecParams == null) {
            return new KeyPair((PublicKey)new BCECPublicKey(this.algorithm, pub, this.configuration), (PrivateKey)new BCECPrivateKey(this.algorithm, priv, this.configuration));
        }
        ECParameterSpec p = (ECParameterSpec)this.ecParams;
        BCECPublicKey pubKey = new BCECPublicKey(this.algorithm, pub, p, this.configuration);
        return new KeyPair((PublicKey)pubKey, (PrivateKey)new BCECPrivateKey(this.algorithm, priv, pubKey, p, this.configuration));
    }

    protected ECKeyGenerationParameters createKeyGenParamsBC(com.xdja.jce.base.spec.ECParameterSpec p, SecureRandom r) {
        return new ECKeyGenerationParameters(new ECDomainParameters(p.getCurve(), p.getG(), p.getN(), p.getH()), r);
    }

    protected ECKeyGenerationParameters createKeyGenParamsJCE(ECParameterSpec p, SecureRandom r) {
        X9ECParameters x9P;
        if (p instanceof ECNamedCurveSpec && (x9P = ECUtils.getDomainParametersFromName((String)((ECNamedCurveSpec)p).getName())) != null) {
            ECDomainParameters dp = new ECDomainParameters(x9P.getCurve(), x9P.getG(), x9P.getN(), x9P.getH());
            return new ECKeyGenerationParameters(dp, r);
        }
        ECCurve curve = EC5Util.convertCurve((EllipticCurve)p.getCurve());
        com.xdja.jce.base.ec.ECPoint g = EC5Util.convertPoint((ECCurve)curve, (ECPoint)p.getGenerator());
        BigInteger n = p.getOrder();
        BigInteger h = BigInteger.valueOf(p.getCofactor());
        ECDomainParameters dp = new ECDomainParameters(curve, g, n, h);
        return new ECKeyGenerationParameters(dp, r);
    }

    protected ECNamedCurveSpec createNamedCurveSpec(String curveName) throws InvalidAlgorithmParameterException {
        X9ECParameters p = ECUtils.getDomainParametersFromName((String)curveName);
        if (p == null) {
            try {
                Map extraCurves;
                p = ECNamedCurveTable.getByOID((ASN1ObjectIdentifier)new ASN1ObjectIdentifier(curveName));
                if (p == null && (p = (X9ECParameters)(extraCurves = this.configuration.getAdditionalECParameters()).get(new ASN1ObjectIdentifier(curveName))) == null) {
                    throw new InvalidAlgorithmParameterException("unknown curve OID: " + curveName);
                }
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidAlgorithmParameterException("unknown curve name: " + curveName);
            }
        }
        byte[] seed = null;
        return new ECNamedCurveSpec(curveName, p.getCurve(), p.getG(), p.getN(), p.getH(), seed);
    }

    protected void initializeNamedCurve(String curveName, SecureRandom random) throws InvalidAlgorithmParameterException {
        ECNamedCurveSpec namedCurve = this.createNamedCurveSpec(curveName);
        this.ecParams = namedCurve;
        this.param = this.createKeyGenParamsJCE((ECParameterSpec)namedCurve, random);
    }

    static {
        ecParameters.put(Integers.valueOf((int)192), new ECGenParameterSpec("prime192v1"));
        ecParameters.put(Integers.valueOf((int)239), new ECGenParameterSpec("prime239v1"));
        ecParameters.put(Integers.valueOf((int)256), new ECGenParameterSpec("prime256v1"));
        ecParameters.put(Integers.valueOf((int)224), new ECGenParameterSpec("P-224"));
        ecParameters.put(Integers.valueOf((int)384), new ECGenParameterSpec("P-384"));
        ecParameters.put(Integers.valueOf((int)521), new ECGenParameterSpec("P-521"));
    }
}

