/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.hash.engine;

import com.xdja.jce.core.util.Memoable;
import com.xdja.jce.core.util.Pack;
import com.xdja.jce.hash.digest.LongDigest;

public class SHA384Digest
extends LongDigest {
    private static final int DIGEST_LENGTH = 48;

    public SHA384Digest() {
    }

    public SHA384Digest(SHA384Digest t) {
        super(t);
    }

    public SHA384Digest(byte[] encodedState) {
        this.restoreState(encodedState);
    }

    @Override
    public String getAlgorithmName() {
        return "SHA-384";
    }

    @Override
    public int getDigestSize() {
        return 48;
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        this.finish();
        Pack.longToBigEndian((long)this.H1, (byte[])out, (int)outOff);
        Pack.longToBigEndian((long)this.H2, (byte[])out, (int)(outOff + 8));
        Pack.longToBigEndian((long)this.H3, (byte[])out, (int)(outOff + 16));
        Pack.longToBigEndian((long)this.H4, (byte[])out, (int)(outOff + 24));
        Pack.longToBigEndian((long)this.H5, (byte[])out, (int)(outOff + 32));
        Pack.longToBigEndian((long)this.H6, (byte[])out, (int)(outOff + 40));
        this.reset();
        return 48;
    }

    @Override
    public void reset() {
        super.reset();
        this.H1 = -3766243637369397544L;
        this.H2 = 7105036623409894663L;
        this.H3 = -7973340178411365097L;
        this.H4 = 1526699215303891257L;
        this.H5 = 7436329637833083697L;
        this.H6 = -8163818279084223215L;
        this.H7 = -2662702644619276377L;
        this.H8 = 5167115440072839076L;
    }

    public Memoable copy() {
        return new SHA384Digest(this);
    }

    public void reset(Memoable other) {
        SHA384Digest d = (SHA384Digest)other;
        super.copyIn(d);
    }

    @Override
    public byte[] getEncodedState() {
        byte[] encoded = new byte[this.getEncodedStateSize()];
        super.populateState(encoded);
        return encoded;
    }
}

