/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jprov.http;

import com.xdja.jprov.http.ProvHttpClient;
import com.xdja.jprov.http.bean.ProvHttpClientConfig;
import com.xdja.jprov.http.bean.ProvHttpRequest;
import com.xdja.jprov.http.bean.ProvHttpResponse;
import com.xdja.jprov.http.bean.ProvHttpsClientConfig;
import com.xdja.jprov.http.bean.ProvProtocol;
import com.xdja.jprov.http.exception.ProvHttpErrorCode;
import com.xdja.jprov.http.exception.ProvHttpException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvHttpsClient
extends ProvHttpClient {
    private Logger logger = LoggerFactory.getLogger(ProvHttpsClient.class);

    public ProvHttpsClient() {
        ProvHttpsClientConfig httpsClientConfig = new ProvHttpsClientConfig();
        httpsClientConfig.setSslEnabled(true);
        httpsClientConfig.setSslProtocol(ProvProtocol.GMSSLv11.getValue());
        this.httpClientConfig = httpsClientConfig;
    }

    public ProvHttpsClient(ProvHttpClientConfig httpClientConfig) {
        super(httpClientConfig);
    }

    public ProvHttpsClient(X509Certificate caCert) throws ProvHttpException {
        this(new X509Certificate[]{caCert});
    }

    public ProvHttpsClient(X509Certificate[] caCerts) throws ProvHttpException {
        ProvHttpsClientConfig httpsClientConfig = new ProvHttpsClientConfig();
        httpsClientConfig.setSslEnabled(true);
        this.logger.info("get caCerts signAlg is " + caCerts[0].getSigAlgName());
        try {
            KeyStore keyStore = KeyStore.getInstance("BKS", "XDJA");
            httpsClientConfig.setSslProtocol(ProvProtocol.GMSSLv11.getValue());
            keyStore.load(null, "password".toCharArray());
            for (int i = 0; i < caCerts.length; ++i) {
                keyStore.setCertificateEntry("trust-" + i, caCerts[i]);
            }
            httpsClientConfig.setTrustStore(keyStore);
            httpsClientConfig.setTrustStorePassword("password");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ProvHttpException("client keystore", ProvHttpErrorCode.GENERATE_TRUST_KEYSTORE__ERROR);
        }
        this.httpClientConfig = httpsClientConfig;
    }

    public ProvHttpsClient(X509Certificate[] caCerts, boolean isByYunHsm) throws ProvHttpException {
        ProvHttpsClientConfig httpsClientConfig = new ProvHttpsClientConfig();
        httpsClientConfig.setSslEnabled(true);
        this.logger.info("get caCerts signAlg is " + caCerts[0].getSigAlgName());
        try {
            KeyStore keyStore;
            if (caCerts[0].getSigAlgName().contains("RSA")) {
                keyStore = KeyStore.getInstance("JKS");
                httpsClientConfig.setSslProtocol(ProvProtocol.TLSV12.getValue());
            } else if (isByYunHsm) {
                keyStore = KeyStore.getInstance("BKS", "XDJA");
                httpsClientConfig.setSslProtocol(ProvProtocol.GMSSLv11.getValue());
            } else {
                keyStore = KeyStore.getInstance("BKS", "XDJA");
                httpsClientConfig.setSslProtocol(ProvProtocol.GMSSLv11.getValue());
            }
            keyStore.load(null, "password".toCharArray());
            for (int i = 0; i < caCerts.length; ++i) {
                keyStore.setCertificateEntry("trust-" + i, caCerts[i]);
            }
            httpsClientConfig.setTrustStore(keyStore);
            httpsClientConfig.setTrustStorePassword("password");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ProvHttpException("client keystore", ProvHttpErrorCode.GENERATE_TRUST_KEYSTORE__ERROR);
        }
        this.httpClientConfig = httpsClientConfig;
    }

    private void checkConfig() throws ProvHttpException {
        if (!(this.httpClientConfig instanceof ProvHttpsClientConfig)) {
            throw new ProvHttpException("config", ProvHttpErrorCode.HTTPS_CONFIG_ERROR);
        }
        ProvHttpsClientConfig httpsClientConfig = (ProvHttpsClientConfig)this.httpClientConfig;
        if (!httpsClientConfig.isSslEnabled() || httpsClientConfig.getSslProtocol() == null) {
            throw new ProvHttpException("ssl protocol", ProvHttpErrorCode.HTTPS_CONFIG_ERROR);
        }
    }

    @Override
    public ProvHttpResponse get(ProvHttpRequest request) throws ProvHttpException {
        this.checkConfig();
        return super.get(request);
    }

    @Override
    public ProvHttpResponse post(ProvHttpRequest request) throws ProvHttpException {
        this.checkConfig();
        return super.post(request);
    }

    @Override
    public ProvHttpResponse put(ProvHttpRequest request) throws ProvHttpException {
        this.checkConfig();
        return super.put(request);
    }

    @Override
    public ProvHttpResponse delete(ProvHttpRequest request) throws ProvHttpException {
        this.checkConfig();
        return super.delete(request);
    }
}

