/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.baselibrary.base;

import android.app.Activity;
import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleOwner;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.DrawableRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.design.widget.BottomSheetDialog;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import com.gyf.immersionbar.ImmersionBar;
import com.orhanobut.logger.Logger;
import com.trello.lifecycle2.android.lifecycle.AndroidLifecycle;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.trello.rxlifecycle2.components.support.RxAppCompatActivity;
import com.xdja.baselibrary.R;
import com.xdja.baselibrary.base.BottomDialogType;
import com.xdja.baselibrary.base.IBaseView;
import com.xdja.baselibrary.base.LoadingType;
import com.xdja.baselibrary.base.bottommenu.BottomMenuBean;
import com.xdja.baselibrary.base.bottommenu.BottomMenuDialogAdapter;
import com.xdja.baselibrary.constant.MomentsConstants;
import com.xdja.baselibrary.exception.MomentsBaseException;
import com.xdja.baselibrary.widget.dialog.MomentsAlertDialog;
import com.xdja.baselibrary.widget.dialog.MomentsProgressDialog;
import com.xdja.baselibrary.widget.stateview.StatusLayoutManager;
import com.xdja.baselibrary.widget.stateview.SwitchStatusLayoutManager;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.EventBus;

public abstract class BaseActivity
extends RxAppCompatActivity
implements IBaseView {
    protected static final int SETTING_REQUEST = 1;
    protected MomentsAlertDialog alertDialog;
    private LoadingType onceLoadingType = LoadingType.LOAD_TYPE_NONE;
    private OnTitleClickListener listener;
    protected LifecycleProvider<Lifecycle.Event> provider;
    private MomentsProgressDialog progressDialog = null;
    protected Toolbar toolbar;
    protected TextView centerTitle;
    protected TextView leftTitle;
    private SwitchStatusLayoutManager statusLayout;
    private BottomSheetDialog bottomSheetDialog;
    private BottomMenuDialogAdapter bottomMenuDialogAdapter;
    private List<BottomMenuBean> bottomMenuBeanList = new ArrayList<BottomMenuBean>();
    private DialogInterface.OnCancelListener cancelListener = dialog -> this.dismissProgressDialog();

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initProvider();
        this.preGetRootView(savedInstanceState);
        this.setContentView(this.getRootView());
        this.initToolBar();
        this.initView();
        this.initBottomDialog(this.initBottomMenuDialog());
        this.initErrorLayout();
        this.initData(this.provider);
        if (this.initEventBus()) {
            EventBus.getDefault().register((Object)this);
        }
    }

    private void initErrorLayout() {
        StatusLayoutManager.Builder builder = new StatusLayoutManager.Builder();
        builder.addErrorClickListener(view -> this.onErrorLayoutClick());
        builder.addEmptyClickListener(view -> this.onEmptyLayoutClick());
        builder.addNoNetWorkClickListener(view -> this.onNoNetLayoutClick());
        if (this.getErrorParentView() != null) {
            this.statusLayout = new StatusLayoutManager(builder).regist(this.getErrorParentView());
            this.statusLayout.showContentView();
        }
    }

    private LoadingType getRealLoadingType() {
        if (this.onceLoadingType == LoadingType.LOAD_TYPE_NONE) {
            return this.getLoadingType();
        }
        return this.onceLoadingType;
    }

    protected abstract void initData(LifecycleProvider<Lifecycle.Event> var1);

    private void initToolBar() {
        this.toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.centerTitle = (TextView)this.findViewById(R.id.tv_title);
        this.leftTitle = (TextView)this.findViewById(R.id.tv_title_left);
        if (this.toolbar != null && !this.ignoreNavigationButton()) {
            this.toolbar.setTitle((CharSequence)"");
            this.setSupportActionBar(this.toolbar);
            this.toolbar.setNavigationIcon(R.drawable.moments_back);
            this.toolbar.setNavigationOnClickListener(v -> this.onToolBarNavigationClick());
        }
        if (this.toolbar != null) {
            ImmersionBar.with((Activity)this).titleBar((View)this.toolbar).keyboardEnable(true).init();
        }
        if (this.centerTitle != null && MomentsConstants.TITLE_GRAVITY == 1) {
            this.centerTitle.setVisibility(0);
            this.leftTitle.setVisibility(8);
            this.centerTitle.setOnClickListener(view -> {
                if (this.listener != null) {
                    this.listener.onTitleClick();
                }
            });
        }
        if (this.leftTitle != null && this.centerTitle != null && MomentsConstants.TITLE_GRAVITY == 0) {
            this.centerTitle.setVisibility(8);
            this.leftTitle.setVisibility(0);
            this.leftTitle.setOnClickListener(view -> {
                if (this.listener != null) {
                    this.listener.onTitleClick();
                }
            });
        }
    }

    protected void onToolBarDoubleTap() {
        Logger.d((Object)"onToolBarDoubleTap");
    }

    protected void setMomentsTitle(String title) {
        if (MomentsConstants.TITLE_GRAVITY == 0) {
            this.leftTitle.setText((CharSequence)title);
        } else {
            this.centerTitle.setText((CharSequence)title);
        }
    }

    protected TextView getTitleTextView() {
        if (MomentsConstants.TITLE_GRAVITY == 0) {
            return this.leftTitle;
        }
        return this.centerTitle;
    }

    protected void setMomentsTitleCompoundDrawables(Drawable top, Drawable right, Drawable botton, Drawable left, int drawablePadding) {
        if (MomentsConstants.TITLE_GRAVITY == 0) {
            this.leftTitle.setCompoundDrawablesRelativeWithIntrinsicBounds(left, top, right, botton);
            this.leftTitle.setCompoundDrawablePadding(drawablePadding);
        } else {
            this.centerTitle.setCompoundDrawablesRelativeWithIntrinsicBounds(left, top, right, botton);
            this.centerTitle.setCompoundDrawablePadding(drawablePadding);
        }
    }

    private void initProvider() {
        this.provider = AndroidLifecycle.createLifecycleProvider((LifecycleOwner)this);
    }

    protected void preGetRootView(Bundle savedInstanceState) {
    }

    protected boolean ignoreNavigationButton() {
        return false;
    }

    protected LoadingType getLoadingType() {
        return LoadingType.LOAD_TYPE_NONE;
    }

    protected ViewGroup getErrorParentView() {
        return null;
    }

    protected void onToolBarNavigationClick() {
        this.finish();
    }

    protected abstract void initView();

    @LayoutRes
    protected abstract int getRootView();

    @Override
    public void showLoading(String msg, String key) {
        switch (this.getRealLoadingType()) {
            case LOAD_TYPE_NONE: {
                Logger.d((Object)"show none loading");
                break;
            }
            case LOAD_TYPE_COVER: {
                Logger.d((Object)"show cover loading");
                this.showLoadingLayout(msg);
                break;
            }
            case LOAD_TYPE_DIALOG: {
                Logger.d((Object)"show progressDialog loading");
                this.showProgressDialog(msg);
                break;
            }
            default: {
                Logger.d((Object)"show none loading");
            }
        }
    }

    protected void showAlertDialog(String leftText, String rightText, String msg, View.OnClickListener leftListenter, View.OnClickListener rightListener) {
        this.showAlertDialog(leftText, rightText, msg, leftListenter, rightListener, true, true);
    }

    protected void showAlertDialog(String rightText, String msg, View.OnClickListener rightListener) {
        this.showAlertDialog(rightText, msg, rightListener, true, true);
    }

    protected void showAlertDialog(String rightText, String msg, View.OnClickListener rightListener, boolean cancelTouch, boolean cancelAble) {
        if (null == this.alertDialog) {
            this.alertDialog = new MomentsAlertDialog();
        }
        this.alertDialog.show((Context)this, rightText, msg, rightListener, cancelTouch, cancelAble);
    }

    protected void showAlertDialog(String leftText, String rightText, String msg, View.OnClickListener leftListenter, View.OnClickListener rightListener, boolean cancelTouch, boolean cancelAble) {
        if (null == this.alertDialog) {
            this.alertDialog = new MomentsAlertDialog();
        }
        this.alertDialog.show((Context)this, leftText, rightText, msg, leftListenter, rightListener, cancelTouch, cancelAble);
    }

    @Override
    public void hideLoading(String key) {
        switch (this.getRealLoadingType()) {
            case LOAD_TYPE_NONE: {
                Logger.d((Object)"hide none loading");
                break;
            }
            case LOAD_TYPE_COVER: {
                Logger.d((Object)"hide cover loading");
                this.hideLoadingLayout();
                break;
            }
            case LOAD_TYPE_DIALOG: {
                Logger.d((Object)"hide progressDialog loading");
                this.dismissProgressDialog();
                break;
            }
            default: {
                Logger.d((Object)"hideLoading");
            }
        }
        this.onceLoadingType = LoadingType.LOAD_TYPE_NONE;
    }

    protected void setOnceLoadingType(LoadingType loadingType) {
        this.onceLoadingType = loadingType;
    }

    @Override
    public void showError(MomentsBaseException ex) {
        this.hideLoadingLayout();
        this.dismissProgressDialog();
        switch (ex.code) {
            case 1002: 
            case 1003: {
                this.showNoNetLayout(ex.errorMessage, this.getString(R.string.baas_net_error_no_net));
                break;
            }
            case 1004: {
                this.showNoNetLayout(ex.errorMessage, this.getString(R.string.baas_net_error_time_out));
                break;
            }
            default: {
                this.showErrorLayout(ex.errorMessage, R.drawable.moments_base_error);
            }
        }
    }

    protected void onPause() {
        super.onPause();
    }

    protected void showProgressDialog(String msg) {
        if (this.progressDialog == null) {
            this.progressDialog = new MomentsProgressDialog();
        }
        this.progressDialog.show((Context)this, msg, this.cancelListener);
    }

    public void showProgressDialog(String msg, boolean cancelable) {
        if (this.progressDialog == null) {
            this.progressDialog = new MomentsProgressDialog();
        }
        this.progressDialog.show((Context)this, msg, cancelable, cancelable, this.cancelListener);
    }

    public void dismissProgressDialog() {
        if (this.statusLayout != null) {
            this.statusLayout.showContentView();
        }
        if (this.progressDialog != null) {
            this.progressDialog.dismiss();
            this.progressDialog = null;
        }
    }

    public void dismissAlertDialog() {
        if (this.statusLayout != null) {
            this.statusLayout.showContentView();
        }
        if (this.alertDialog != null) {
            this.alertDialog.dismiss();
            this.alertDialog = null;
        }
    }

    protected void showLoadingLayout() {
        if (this.statusLayout != null) {
            this.statusLayout.showLoadingView();
        } else {
            Toast.makeText((Context)this, (CharSequence)"\u52a0\u8f7d\u6570\u636e", (int)0).show();
        }
    }

    protected void showLoadingLayout(String loadingText) {
        if (this.statusLayout != null) {
            this.statusLayout.showLoadingView(loadingText);
        } else {
            Toast.makeText((Context)this, (CharSequence)loadingText, (int)0).show();
        }
    }

    protected void showNoNetLayout(String netErrorText, String subText) {
        this.showNoNetLayout(netErrorText, subText, R.drawable.moments_base_network_error);
    }

    protected void showNoNetLayout(String netErrorText) {
        this.showNoNetLayout(netErrorText, null, R.drawable.moments_base_network_error);
    }

    protected void showNoNetLayout(String netErrorText, String subText, @DrawableRes int netErrorImage) {
        if (this.statusLayout != null) {
            this.statusLayout.showNoNetWorkView(netErrorText, subText, netErrorImage);
        } else {
            Toast.makeText((Context)this, (CharSequence)netErrorText, (int)0).show();
        }
    }

    protected void showEmptyLayout(String emptyText) {
        this.showEmptyLayout(emptyText, R.drawable.moments_base_empty);
    }

    protected void showEmptyLayout(String emptyText, @DrawableRes int emptyImage) {
        if (this.statusLayout != null) {
            this.statusLayout.showEmptyView(emptyText, emptyImage);
        } else {
            Toast.makeText((Context)this, (CharSequence)emptyText, (int)0).show();
        }
    }

    protected void showErrorLayout(String errorInfo) {
        this.showErrorLayout(errorInfo, R.drawable.moments_base_empty);
    }

    protected void showErrorLayout(String errorInfo, @DrawableRes int errorImage) {
        if (this.statusLayout != null) {
            this.statusLayout.showErrorView(errorInfo, errorImage);
        } else {
            Toast.makeText((Context)this, (CharSequence)errorInfo, (int)0).show();
        }
    }

    protected void hideLoadingLayout() {
        if (this.statusLayout != null) {
            this.statusLayout.hideStatusView(1);
            this.statusLayout.showContentView();
        }
    }

    protected void hideNoNetLayout() {
        if (this.statusLayout != null) {
            this.statusLayout.hideStatusView(4);
            this.statusLayout.showContentView();
        }
    }

    protected void hideEmptyLayout() {
        if (this.statusLayout != null) {
            this.statusLayout.hideStatusView(3);
            this.statusLayout.showContentView();
        }
    }

    protected void hideErrorLayout() {
        if (this.statusLayout != null) {
            this.statusLayout.hideStatusView(2);
            this.statusLayout.showContentView();
        }
    }

    protected void onErrorLayoutClick() {
        this.hideErrorLayout();
        this.initData(this.provider);
    }

    protected void onNoNetLayoutClick() {
        this.hideNoNetLayout();
        this.initData(this.provider);
    }

    protected void onEmptyLayoutClick() {
        this.hideEmptyLayout();
        this.initData(this.provider);
    }

    protected boolean initEventBus() {
        return false;
    }

    protected void onDestroy() {
        super.onDestroy();
        this.dismissProgressDialog();
        if (this.initEventBus()) {
            EventBus.getDefault().unregister((Object)this);
        }
        if (this.statusLayout != null) {
            this.statusLayout.release();
        }
        if (this.bottomSheetDialog != null) {
            this.bottomSheetDialog.dismiss();
        }
    }

    @Override
    public void showToast(String msg) {
        Toast.makeText((Context)this, (CharSequence)msg, (int)0).show();
    }

    protected void showPermissionDeniedDialog(@StringRes int messageResId) {
        this.showAlertDialog("\u786e\u5b9a", this.getResources().getString(messageResId), view -> {
            this.dismissAlertDialog();
            Intent intent = new Intent();
            intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
            intent.setData(Uri.fromParts((String)"package", (String)this.getPackageName(), null));
            this.startActivityForResult(intent, 1);
        }, false, false);
    }

    public void setOnTitleClickListener(OnTitleClickListener listener) {
        this.listener = listener;
    }

    protected BottomDialogType initBottomMenuDialog() {
        return BottomDialogType.BOTTOM_TYPE_NONE;
    }

    private void initBottomDialog(BottomDialogType type) {
        if (type == BottomDialogType.BOTTOM_TYPE_NONE) {
            return;
        }
        this.bottomSheetDialog = new BottomSheetDialog((Context)this);
        LayoutInflater inflater = (LayoutInflater)this.getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.moments_bottom_menu_dialog, null);
        RecyclerView recyclerView = (RecyclerView)view.findViewById(R.id.recycleView);
        if (BottomDialogType.BOTTOM_TYPE_LIST == type) {
            recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        } else if (BottomDialogType.BOTTOM_TYPE_GIRD == type) {
            recyclerView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager((Context)this, 4));
        }
        this.bottomMenuDialogAdapter = new BottomMenuDialogAdapter(recyclerView, this.bottomMenuBeanList, this.getApplicationContext(), type);
        this.bottomMenuDialogAdapter.setOnItemClickListener((v, position) -> this.onBottomMenuItemClick(position));
        recyclerView.setAdapter((RecyclerView.Adapter)this.bottomMenuDialogAdapter);
        this.bottomSheetDialog.setCanceledOnTouchOutside(true);
        this.bottomSheetDialog.setContentView(view);
    }

    protected void showBottomMenu(List<BottomMenuBean> bottomMenuBeanList) {
        if (this.bottomSheetDialog == null) {
            throw new IllegalArgumentException("\nBottomMenuDialog\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528initBottomMenuDialog()\u65b9\u6cd5\uff0c\u5e76\u8fd4\u56de\u5bf9\u5e94Type");
        }
        this.bottomMenuBeanList.clear();
        this.bottomMenuDialogAdapter.addAll(bottomMenuBeanList);
        this.bottomMenuDialogAdapter.notifyDataSetChanged();
        this.bottomSheetDialog.show();
    }

    protected void hideBottomMenu() {
        if (this.bottomSheetDialog == null) {
            throw new IllegalArgumentException("\nBottomMenuDialog\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528initBottomMenuDialog()\u65b9\u6cd5\uff0c\u5e76\u8fd4\u56de\u5bf9\u5e94Type");
        }
        this.bottomMenuBeanList.clear();
        this.bottomSheetDialog.hide();
    }

    protected void onBottomMenuItemClick(int position) {
        Toast.makeText((Context)this, (CharSequence)("bottom menu: " + position), (int)0).show();
    }

    public void hideKeyboard(View v) {
        ((InputMethodManager)this.getSystemService("input_method")).hideSoftInputFromWindow(v.getWindowToken(), 2);
    }

    public void hideKeyboard() {
        Window window = this.getWindow();
        if (window != null) {
            this.hideKeyboard(window.getDecorView());
        }
    }

    public void showKeyboard(EditText et) {
        ((InputMethodManager)this.getSystemService("input_method")).showSoftInput((View)et, 1);
    }

    public void hideInputSoft() {
        View currentFocus = this.getCurrentFocus();
        if (currentFocus != null) {
            currentFocus.clearFocus();
            InputMethodManager inputMethodManager = (InputMethodManager)this.getSystemService("input_method");
            if (inputMethodManager != null) {
                inputMethodManager.hideSoftInputFromWindow(currentFocus.getWindowToken(), 0);
            }
        }
    }

    public static interface OnTitleClickListener {
        public void onTitleClick();
    }
}

