/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.baselibrary.base;

import com.xdja.baselibrary.base.IBaseView;
import com.xdja.baselibrary.exception.ErrorSubscriber;
import com.xdja.baselibrary.exception.MomentsBaseException;
import io.reactivex.disposables.Disposable;

public class BaseObserver<T>
extends ErrorSubscriber<T> {
    private IBaseView baseView;
    private String loadingText;
    protected boolean showLoading;
    private String requestPath = "DEFAULT";

    public BaseObserver(IBaseView view, boolean showLoading) {
        this(view, showLoading, "\u6b63\u5728\u52a0\u8f7d\u2026\u2026");
    }

    public BaseObserver(IBaseView view, String loadingText) {
        this(view, true, loadingText);
    }

    public BaseObserver(IBaseView view, String loadingText, String requestPath) {
        this(view, true, loadingText, requestPath);
    }

    public BaseObserver(IBaseView view, boolean showLoading, String loadingText) {
        this(view, showLoading, loadingText, "DEFAULT");
    }

    public BaseObserver(IBaseView view, boolean showLoading, String loadingText, String requestPath) {
        this.baseView = view;
        this.showLoading = showLoading;
        this.loadingText = loadingText;
        this.requestPath = requestPath;
    }

    public void onSubscribe(Disposable d) {
        if (this.showLoading) {
            this.baseView.showLoading(this.loadingText, this.requestPath);
        }
    }

    public void onNext(T t) {
        if (this.showLoading) {
            this.baseView.hideLoading(this.requestPath);
        }
    }

    @Override
    protected void onError(MomentsBaseException ex) {
        if (this.showLoading) {
            this.baseView.hideLoading(this.requestPath);
        }
        ex.setKeyPath(this.requestPath);
        this.baseView.showError(ex);
        ex.printStackTrace();
    }

    public void onComplete() {
    }
}

