/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.baselibrary.base.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.xdja.baselibrary.base.adapter.ViewHolder;
import java.util.ArrayList;
import java.util.List;

public abstract class CommonAdapter<D>
extends BaseAdapter {
    public Context mContext = null;
    protected List<D> listData = new ArrayList<D>();

    public CommonAdapter(Context context) {
        this.mContext = context;
    }

    public int getItemViewType(int position) {
        if (this.listData == null || this.listData.isEmpty()) {
            return super.getItemViewType(position);
        }
        return super.getItemViewType(position);
    }

    public int getCount() {
        if (this.listData == null) {
            return 0;
        }
        return this.listData.size();
    }

    public Object getItem(int position) {
        return this.listData.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public void addDataList(List<D> mList) {
        if (this.listData != null) {
            this.listData.addAll(mList);
        }
        this.notifyDataSetChanged();
    }

    public void addData(D data) {
        if (this.listData != null) {
            this.listData.add(data);
        }
        this.notifyDataSetChanged();
    }

    public void clearDataList() {
        if (this.listData != null) {
            this.listData.clear();
        }
        this.notifyDataSetChanged();
    }

    public void removeData(int position) {
        if (this.listData != null) {
            this.listData.remove(position);
        }
        this.notifyDataSetChanged();
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder = ViewHolder.getViewHolder(this.mContext, parent, convertView, position, this.getLayoutResId());
        this.onBindView(viewHolder, this.listData.get(position));
        return viewHolder.getConvertView();
    }

    public abstract void onBindView(ViewHolder var1, D var2);

    public abstract int getLayoutResId();
}

