/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.baselibrary.base.adapter.decoration;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.RecyclerView;
import android.view.View;

public class LeftOffsetItemDecoration
extends RecyclerView.ItemDecoration {
    private Drawable mDivider;
    private int leftOffset;
    private int driverHeight;

    public LeftOffsetItemDecoration(int color, int driverHeight, int leftOffset) {
        this.mDivider = new ColorDrawable(color);
        this.leftOffset = leftOffset;
        this.driverHeight = driverHeight;
    }

    public void onDraw(Canvas c, RecyclerView parent) {
        this.drawVertical(c, parent);
    }

    public void drawVertical(Canvas c, RecyclerView parent) {
        int right = parent.getWidth() - parent.getPaddingRight();
        int childCount = parent.getChildCount();
        RecyclerView.Adapter adapter = parent.getAdapter();
        int realItemCount = adapter == null ? childCount : adapter.getItemCount();
        for (int i = 0; i < childCount; ++i) {
            if (i == 0) continue;
            View child = parent.getChildAt(i);
            int position = parent.getChildAdapterPosition(child);
            int left = position + 1 == realItemCount ? parent.getPaddingLeft() : parent.getPaddingLeft() + this.leftOffset;
            int top = child.getTop();
            int bottom = child.getTop() + this.driverHeight;
            this.mDivider.setBounds(left, top, right, bottom);
            this.mDivider.draw(c);
        }
    }

    public void getItemOffsets(Rect outRect, int itemPosition, RecyclerView parent) {
        outRect.set(0, this.driverHeight, 0, 0);
    }
}

