/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.baselibrary.http;

import com.xdja.baselibrary.constant.ConstantUrl;
import com.xdja.baselibrary.util.gsonconvent.GsonConverterFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;

public class ApiManager {
    private static ApiManager instance = null;
    private static final long DEFAULT_TIME_OUT = 30L;
    private static Retrofit retrofit;
    private static HashMap<String, List<Cookie>> cookieStore;

    private ApiManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApiManager getInstance() {
        Class<ApiManager> clazz = ApiManager.class;
        synchronized (ApiManager.class) {
            if (instance == null) {
                instance = new ApiManager();
                OkHttpClient.Builder builder = new OkHttpClient.Builder();
                builder.connectTimeout(30L, TimeUnit.SECONDS);
                builder.readTimeout(30L, TimeUnit.SECONDS);
                builder.writeTimeout(30L, TimeUnit.SECONDS);
                builder.addInterceptor((Interceptor)ApiManager.getLoggingInterceptor());
                builder.addInterceptor((Interceptor)new HttpHeadInterceptor());
                builder.cookieJar(new CookieJar(){

                    public void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
                        ArrayList<Cookie> locals = (ArrayList<Cookie>)cookieStore.get(url.host());
                        block0: for (int i = 0; i < cookies.size() && locals != null && !locals.isEmpty(); ++i) {
                            boolean hasName = false;
                            for (int j = 0; j < locals.size(); ++j) {
                                if (((Cookie)locals.get(j)).name().equals(cookies.get(i).name())) {
                                    locals.set(j, cookies.get(i));
                                    hasName = true;
                                    continue block0;
                                }
                                if (hasName) continue;
                                locals.add(cookies.get(i));
                            }
                        }
                        if (locals == null) {
                            locals = new ArrayList<Cookie>(cookies);
                        }
                        cookieStore.put(url.host(), locals);
                    }

                    public List<Cookie> loadForRequest(HttpUrl url) {
                        List cookies = (List)cookieStore.get(url.host());
                        return cookies != null ? cookies : new ArrayList();
                    }
                });
                OkHttpClient client = builder.build();
                Retrofit.Builder retrofitBuilder = new Retrofit.Builder();
                retrofit = retrofitBuilder.baseUrl("http://" + ConstantUrl.MOMENTS_HOST + ":" + ConstantUrl.MOMENTS_PORT + "/moment/mobile/").client(client).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public <T> T getApi(Class<T> cls) {
        return (T)retrofit.create(cls);
    }

    private static HttpLoggingInterceptor getLoggingInterceptor() {
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
        logging.setLevel(HttpLoggingInterceptor.Level.BODY);
        return logging;
    }

    static {
        cookieStore = new HashMap();
    }

    private static class HttpHeadInterceptor
    implements Interceptor {
        private HttpHeadInterceptor() {
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request originalRequest = chain.request();
            Request newRequest = originalRequest.newBuilder().header("Content-Type", "application/json").header("charset", "utf-8").header("User-Agent", "Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.87 Safari/537.36").build();
            Response proceed = chain.proceed(newRequest);
            return proceed;
        }
    }
}

