/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.baselibrary.util.gsonconvent;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.xdja.baselibrary.base.BaseResult;
import com.xdja.baselibrary.exception.ServerException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import retrofit2.Converter;

final class GsonResponseBodyConverter<T>
implements Converter<ResponseBody, T> {
    private final Gson gson;
    private final TypeAdapter<T> adapter;

    GsonResponseBodyConverter(Gson gson, TypeAdapter<T> adapter) {
        this.gson = gson;
        this.adapter = adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T convert(ResponseBody value) throws IOException {
        Type type;
        String response = value.string();
        BaseResult httpStatus = (BaseResult)this.gson.fromJson(response, type = new TypeToken<BaseResult<Object>>(){}.getType());
        if (!httpStatus.getFlag().equals("1")) {
            value.close();
            String errorMsg = httpStatus.getMessage();
            throw new ServerException(httpStatus.getErrorCode(), errorMsg);
        }
        MediaType contentType = value.contentType();
        Charset charset = contentType != null ? contentType.charset(Util.UTF_8) : Util.UTF_8;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(response.getBytes());
        InputStreamReader reader = new InputStreamReader((InputStream)inputStream, charset);
        JsonReader jsonReader = this.gson.newJsonReader((Reader)reader);
        try {
            Object object = this.adapter.read(jsonReader);
            return (T)object;
        }
        finally {
            value.close();
        }
    }
}

